/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.chart.LineChart;
import de.willuhn.jameica.hbci.gui.chart.LineChartData;
import de.willuhn.jameica.hbci.gui.chart.LineStyle;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.UmsatzTreeNode;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.util.DateUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class UmsatzTypVerlauf
implements Part {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private List data = null;
    private Date start = null;
    private Date stop = null;
    private LineChart chart = null;
    private Interval interval = Interval.MONTH;

    public void setData(List data, Date start, Date stop) {
        this.data = data;
        this.start = start;
        this.stop = stop;
    }

    public void redraw() throws RemoteException {
        if (this.chart == null) {
            return;
        }
        this.chart.removeAllData();
        int count = 0;
        int i = 0;
        while (i < this.data.size()) {
            UmsatzTreeNode group = (UmsatzTreeNode)this.data.get(i);
            ChartDataUmsatz cd = new ChartDataUmsatz(group, this.interval);
            if (cd.hasData) {
                this.chart.addData(cd);
                count = cd.entries.size();
            }
            ++i;
        }
        if (count <= 1) {
            this.chart.setTitle(i18n.tr("Bitte w\u00e4hlen Sie einen gr\u00f6\u00dferen Zeitraum"));
        } else {
            this.chart.setTitle(i18n.tr("Ums\u00e4tze der Kategorien im Verlauf (gruppiert nach {0})", this.interval.toString()));
        }
        this.chart.redraw();
    }

    public void paint(Composite parent) throws RemoteException {
        try {
            this.chart = new LineChart();
            this.chart.setStacked(false);
            this.chart.setTitle(i18n.tr("Ums\u00e4tze der Kategorien im Verlauf (gruppiert nach {0})", this.interval.toString()));
            int i = 0;
            while (i < this.data.size()) {
                UmsatzTreeNode group = (UmsatzTreeNode)this.data.get(i);
                ChartDataUmsatz cd = new ChartDataUmsatz(group, this.interval);
                if (cd.hasData) {
                    this.chart.addData(cd);
                }
                ++i;
            }
            this.chart.paint(parent);
            this.addGroupingMenu();
        }
        catch (RemoteException re) {
            throw re;
        }
        catch (Exception e) {
            Logger.error((String)"unable to create chart", (Throwable)e);
            Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Erzeugen des Diagramms"), 1));
        }
    }

    private void addGroupingMenu() {
        Menu m = this.chart.getChart().getPlotArea().getControl().getMenu();
        MenuItem groupMenuItem = new MenuItem(m, 64, 0);
        groupMenuItem.setText(i18n.tr("Gruppierung nach"));
        new MenuItem(m, 2, 1);
        Menu groupMenu = new Menu(groupMenuItem);
        groupMenuItem.setMenu(groupMenu);
        final ArrayList<MenuItem> items = new ArrayList<MenuItem>();
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MenuItem item = (MenuItem)e.getSource();
                Iterator iterator = items.iterator();
                while (iterator.hasNext()) {
                    MenuItem i;
                    i.setSelection((i = (MenuItem)iterator.next()) == item);
                }
                UmsatzTypVerlauf.this.interval = (Interval)((Object)item.getData());
                try {
                    UmsatzTypVerlauf.this.redraw();
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to redraw chart", (Throwable)re);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Aktualisieren"), 1));
                }
            }
        };
        Interval[] intervalArray = Interval.values();
        int n = intervalArray.length;
        int n2 = 0;
        while (n2 < n) {
            Interval i = intervalArray[n2];
            MenuItem item = new MenuItem(groupMenu, 32);
            item.setText(i.toString());
            item.setSelection(this.interval == i);
            item.setData((Object)i);
            item.addSelectionListener((SelectionListener)l);
            items.add(item);
            ++n2;
        }
    }

    private class ChartDataUmsatz
    implements LineChartData {
        private UmsatzTreeNode group = null;
        private List<Entry> entries = new ArrayList<Entry>();
        private boolean hasData = false;
        private Date chartStartDate = null;
        private Date chartStopDate = null;

        private List<Umsatz> getRecursiveUmsaetze(UmsatzTreeNode group) {
            ArrayList<Umsatz> result = new ArrayList<Umsatz>(group.getUmsaetze());
            for (UmsatzTreeNode unterkategorie : group.getSubGroups()) {
                result.addAll(this.getRecursiveUmsaetze(unterkategorie));
            }
            return result;
        }

        private ChartDataUmsatz(UmsatzTreeNode group, Interval interval) throws RemoteException {
            HashMap<Date, Double> verteilung = new HashMap<Date, Double>();
            Calendar calendar = Calendar.getInstance();
            this.group = group;
            this.entries.clear();
            for (Umsatz umsatz : this.getRecursiveUmsaetze(group)) {
                if (umsatz.getDatum() == null) {
                    Logger.warn((String)"no date found for umsatz, skipping record");
                    continue;
                }
                this.hasData = true;
                calendar.setTime(DateUtil.startOfDay((Date)umsatz.getDatum()));
                calendar.set(interval.type, 1);
                Date key = calendar.getTime();
                double aggMonatsWert = verteilung.containsKey(key) ? (Double)verteilung.get(key) : 0.0;
                verteilung.put(key, umsatz.getBetrag() + aggMonatsWert);
            }
            this.calculateChartInterval(verteilung.keySet());
            calendar.setTime(DateUtil.startOfDay((Date)this.chartStartDate));
            calendar.set(interval.type, 1);
            Date next = calendar.getTime();
            while (!next.after(this.chartStopDate)) {
                Entry aktuellerWert = new Entry();
                aktuellerWert.monat = next;
                if (verteilung.containsKey(next)) {
                    aktuellerWert.betrag = (Double)verteilung.get(next);
                }
                this.entries.add(aktuellerWert);
                calendar.setTime(next);
                calendar.add(interval.size, 1);
                next = calendar.getTime();
            }
            Entry lastEntry = new Entry();
            lastEntry.monat = next;
            this.entries.add(lastEntry);
        }

        private void calculateChartInterval(Set<Date> chartDates) {
            Date min = new Date();
            Date max = new Date();
            if (!chartDates.isEmpty()) {
                min = Collections.min(chartDates);
                max = Collections.max(chartDates);
            }
            this.chartStartDate = UmsatzTypVerlauf.this.start != null && UmsatzTypVerlauf.this.start.after(min) ? UmsatzTypVerlauf.this.start : min;
            this.chartStopDate = UmsatzTypVerlauf.this.stop != null && UmsatzTypVerlauf.this.stop.before(max) ? UmsatzTypVerlauf.this.start : max;
        }

        @Override
        public List getData() throws RemoteException {
            return this.entries;
        }

        @Override
        public String getLabel() throws RemoteException {
            return (String)this.group.getAttribute("name");
        }

        @Override
        public String getDataAttribute() throws RemoteException {
            return "betrag";
        }

        @Override
        public String getLabelAttribute() throws RemoteException {
            return "monat";
        }

        @Override
        public int getLineWidth() throws RemoteException {
            return 1;
        }

        @Override
        public LineStyle getLineStyle() throws RemoteException {
            return null;
        }

        @Override
        public boolean isLegendEnabled() throws RemoteException {
            return true;
        }

        @Override
        public boolean getCurve() {
            return false;
        }

        @Override
        public int[] getColor() throws RemoteException {
            UmsatzTyp ut = this.group.getUmsatzTyp();
            if (ut == null) {
                return null;
            }
            if (!ut.isCustomColor()) {
                return null;
            }
            return ut.getColor();
        }

        @Override
        public boolean isFilled() throws RemoteException {
            return true;
        }
    }

    private class Entry
    implements GenericObject {
        private double betrag = 0.0;
        private Date monat;

        private Entry() {
        }

        public boolean equals(GenericObject other) throws RemoteException {
            if (other == null || other.getID() == null) {
                return false;
            }
            return other.getID().equals(this.getID());
        }

        public Object getAttribute(String name) throws RemoteException {
            if ("betrag".equals(name)) {
                return this.betrag;
            }
            if ("monat".equals(name)) {
                return this.monat;
            }
            return null;
        }

        public String[] getAttributeNames() throws RemoteException {
            return new String[]{"betrag", "monat"};
        }

        public String getID() throws RemoteException {
            if (this.monat == null) {
                return "foo";
            }
            return this.monat.toString();
        }

        public String getPrimaryAttribute() throws RemoteException {
            return "betrag";
        }
    }

    private static enum Interval {
        YEAR(6, 1, i18n.tr("Jahr")),
        MONTH(5, 2, i18n.tr("Monat")),
        WEEK(7, 3, i18n.tr("Woche"));

        private int type;
        private int size;
        private String name;

        private Interval(int type, int size, String name) {
            this.type = type;
            this.size = size;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

