/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.parts.columns;

import de.willuhn.jameica.gui.parts.AbstractTablePart;
import de.willuhn.jameica.gui.parts.Column;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.rmi.Terminable;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.Date;

public class AusgefuehrtColumn
extends Column {
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public AusgefuehrtColumn() {
        this("ausgefuehrt_am");
    }

    public AusgefuehrtColumn(String name) {
        super(name, i18n.tr("Ausgef\u00fchrt?"), null, false, 131072);
    }

    public String getFormattedValue(Object value, Object context) {
        if (context != null && context instanceof Terminable) {
            try {
                Terminable t = (Terminable)context;
                if (!t.ausgefuehrt()) {
                    return i18n.tr("offen");
                }
                if (value != null && value instanceof Date) {
                    return HBCI.LONGDATEFORMAT.format((Date)value);
                }
                return i18n.tr("ausgef\u00fchrt");
            }
            catch (RemoteException re) {
                Logger.error((String)("unable to format attribute " + value + " for bean " + context));
            }
        }
        return super.getFormattedValue(value, context);
    }

    public int compare(AbstractTablePart.AbstractTableItem i1, AbstractTablePart.AbstractTableItem i2) {
        if (i1.sortValue == null) {
            return 1;
        }
        if (i2.sortValue == null) {
            return -1;
        }
        return super.compare(i1, i2);
    }
}

