/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.MultiInput;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.controller.UmsatzDetailControl;
import de.willuhn.jameica.hbci.messaging.NeueUmsaetze;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractUmsatzDetail
extends AbstractView {
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    protected abstract UmsatzDetailControl getControl();

    public void bind() throws Exception {
        UmsatzDetailControl control = this.getControl();
        Umsatz u = control.getUmsatz();
        Konto k = u.getKonto();
        String s1 = k.getLongName();
        if (s1 == null) {
            s1 = "";
        }
        double d = k.getSaldo();
        String s2 = null;
        if (k.getSaldoDatum() != null) {
            s2 = String.valueOf(HBCI.DECIMALFORMAT.format(d)) + " " + k.getWaehrung();
        }
        if (s2 == null) {
            GUI.getView().setTitle(i18n.tr("Buchungsdetails. {0}", s1));
        } else {
            GUI.getView().setTitle(i18n.tr("Buchungsdetails. {0}, Saldo: {1}", new String[]{s1, s2}));
        }
        ColumnLayout columns = new ColumnLayout(this.getParent(), 2);
        SimpleContainer left = new SimpleContainer(columns.getComposite());
        left.addHeadline(i18n.tr("Gegenkonto"));
        left.addLabelPair(i18n.tr("Name"), control.getEmpfaengerName());
        if (StringUtils.isNotBlank((String)control.getUmsatz().getGegenkontoName2())) {
            left.addInput(control.getEmpfaengerName2());
        }
        left.addInput(control.getEmpfaengerKonto());
        left.addInput(control.getEmpfaengerBLZ());
        left.addHeadline(i18n.tr("Datum und Betrag"));
        left.addLabelPair(i18n.tr("Datum"), control.getDatum());
        left.addLabelPair(i18n.tr("Wertstellung"), control.getValuta());
        left.addSeparator();
        left.addLabelPair(i18n.tr("Betrag"), control.getBetrag());
        left.addLabelPair(i18n.tr("Neuer Saldo"), control.getSaldo());
        SimpleContainer right = new SimpleContainer(columns.getComposite(), true);
        right.addHeadline(i18n.tr("Sonstige Informationen"));
        right.addLabelPair(i18n.tr("Art der Buchung"), control.getArt());
        right.addInput(control.getEndToEndId());
        right.addInput(control.getCreditorId());
        right.addLabelPair(i18n.tr("Kunden-/Mandatsreferenz"), (Input)new MultiInput(new Input[]{control.getCustomerRef(), control.getMandateId()}));
        right.addLabelPair(i18n.tr("Primanota/GV-Code"), (Input)new MultiInput(new Input[]{control.getPrimanota(), control.getGvCode()}));
        right.addHeadline(i18n.tr("Notizen"));
        right.addPart((Part)control.getKommentar());
        SimpleContainer bottom = new SimpleContainer(this.getParent(), true);
        bottom.addSeparator();
        bottom.addLabelPair(i18n.tr("Kategorie"), (Input)control.getUmsatzTyp());
        bottom.addHeadline(i18n.tr("Verwendungszweck"));
        bottom.addPart((Part)control.getZweck());
        bottom.addInput((Input)control.getZweckSwitch());
        this.forceSaldoUpdateforReverseBooking();
        NeueUmsaetze.setRead(u);
    }

    private void forceSaldoUpdateforReverseBooking() {
        if (this.getCurrentObject() instanceof Umsatz) {
            Umsatz umsatz = (Umsatz)this.getCurrentObject();
            try {
                if (umsatz.isNewObject() && umsatz.getKonto().hasFlag(2)) {
                    this.getControl().getBetrag().getControl().forceFocus();
                    this.getControl().getUmsatzTyp().focus();
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }
}

