/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.internal.parts.PanelButtonPrint;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungDelete;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungExecute;
import de.willuhn.jameica.hbci.gui.action.Duplicate;
import de.willuhn.jameica.hbci.gui.controller.AuslandsUeberweisungControl;
import de.willuhn.jameica.hbci.gui.parts.PanelButtonNew;
import de.willuhn.jameica.hbci.io.print.PrintSupportAuslandsUeberweisung;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.print.PrintSupport;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class AuslandsUeberweisungNew
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = new MyMessageConsumer();
    private AuslandsUeberweisung transfer = null;

    public void bind() throws Exception {
        final AuslandsUeberweisungControl control = new AuslandsUeberweisungControl(this);
        this.transfer = control.getTransfer();
        GUI.getView().setTitle(i18n.tr("SEPA-\u00dcberweisung bearbeiten"));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonNew(AuslandsUeberweisung.class));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonPrint((PrintSupport)new PrintSupportAuslandsUeberweisung(this.transfer)));
        SimpleContainer cl = new SimpleContainer(this.getParent());
        cl.addHeadline(i18n.tr("Konto"));
        cl.addInput(control.getKontoAuswahl());
        ColumnLayout cols = new ColumnLayout(this.getParent(), 2);
        SimpleContainer container = new SimpleContainer(cols.getComposite());
        container.addHeadline(i18n.tr("Empf\u00e4nger"));
        container.addLabelPair(i18n.tr("Name"), (Input)control.getEmpfaengerName());
        container.addLabelPair(i18n.tr("IBAN"), (Input)control.getEmpfaengerKonto());
        container.addLabelPair(i18n.tr("BIC"), control.getEmpfaengerBic());
        container.addInput((Input)control.getStoreEmpfaenger());
        container.addHeadline(i18n.tr("Auftragswiederholung (nur Hibiscus-intern)"));
        container.addText(i18n.tr("Diese Information wird nicht an die Bank \u00fcbertragen."), true);
        container.addInput((Input)control.getReminderInterval());
        container = new SimpleContainer(cols.getComposite());
        container.addHeadline(i18n.tr("SEPA"));
        container.addInput(control.getEndToEndId());
        container.addInput(control.getPmtInfId());
        container.addInput(control.getPurposeCode());
        container.addHeadline(i18n.tr("Sonstige Informationen"));
        container.addInput((Input)control.getTyp());
        container.addInput((Input)control.getTermin());
        container = new SimpleContainer(this.getParent());
        container.addHeadline(i18n.tr("Details"));
        container.addLabelPair(i18n.tr("Verwendungszweck"), control.getZweck());
        container.addLabelPair(i18n.tr("Betrag"), control.getBetrag());
        ButtonArea buttonArea = new ButtonArea();
        buttonArea.addButton(i18n.tr("L\u00f6schen"), (Action)new AuslandsUeberweisungDelete(), (Object)this.transfer, false, "user-trash-full.png");
        buttonArea.addButton(i18n.tr("Duplizieren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (control.handleStore()) {
                    new Duplicate().handleAction(AuslandsUeberweisungNew.this.transfer);
                }
            }
        }, null, false, "edit-copy.png");
        Button execute = new Button(i18n.tr("Jetzt ausf\u00fchren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (control.handleStore()) {
                    new AuslandsUeberweisungExecute().handleAction(AuslandsUeberweisungNew.this.transfer);
                }
            }
        }, null, false, "emblem-important.png");
        execute.setEnabled(!this.transfer.ausgefuehrt());
        Button store = new Button(i18n.tr("&Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, !this.transfer.ausgefuehrt(), "document-save.png");
        store.setEnabled(!this.transfer.ausgefuehrt());
        buttonArea.addButton(execute);
        buttonArea.addButton(store);
        buttonArea.paint(this.getParent());
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    public void unbind() throws ApplicationException {
        super.unbind();
        this.transfer = null;
        Application.getMessagingFactory().unRegisterMessageConsumer(this.mc);
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (AuslandsUeberweisungNew.this.transfer == null) {
                return;
            }
            GenericObject o = ((ObjectChangedMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (AuslandsUeberweisungNew.this.transfer.equals(o)) {
                GUI.startView((AbstractView)AuslandsUeberweisungNew.this, (Object)AuslandsUeberweisungNew.this.transfer);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

