/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.AuslandsUeberweisungNew;
import de.willuhn.jameica.hbci.gui.action.SepaDauerauftragNew;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.Turnus;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.util.Calendar;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DonateView
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void bind() throws Exception {
        GUI.getView().setTitle(i18n.tr("Spenden f\u00fcr Hibiscus"));
        Composite comp = new Composite(this.getParent(), 0);
        comp.setLayoutData((Object)new GridData(768));
        comp.setLayout((Layout)SWTUtil.createGrid((int)2, (boolean)false));
        SimpleContainer container = new SimpleContainer(comp);
        container.addHeadline(String.valueOf(i18n.tr("Warum eigentlich?")) + "  ");
        container.addText(i18n.tr("Viele Opensource-Anwendungen werden nicht von finanzstarken Unternehmen programmiert sondern von freiwilligen Entwicklern, die das in ihrer Freizeit tun. Hibiscus ist ein solches Projekt.\n\nNeben der Zeit, die ich f\u00fcr die Weiterentwicklung von Hibiscus investiere, ben\u00f6tige ich nat\u00fcrlich auch Geld f\u00fcr die Miete des Webservers, f\u00fcr zu testende Chipkarten-Leser und auch f\u00fcr die Computer und Betriebssysteme, auf denen Hibiscus laufen soll. Leider konnte ich bisher kein Unternehmen finden, welches mich sponsert."), true);
        Canvas c = SWTUtil.getCanvas((Composite)comp, (Image)SWTUtil.getImage((String)"hibiscus-donate.png"), (int)16512);
        ((GridData)c.getLayoutData()).minimumWidth = 157;
        SimpleContainer container2 = new SimpleContainer(this.getParent());
        container2.addHeadline(i18n.tr("Unterst\u00fctzen"));
        container2.addText(i18n.tr("Ich w\u00fcrde mich freuen, wenn Sie das Projekt mit unterst\u00fctzen wollen. Durch Klick auf \"Dauerauftrag erstellen\" bzw. \"...oder \u00dcberweisung\" k\u00f6nnen Sie eine einmalige \u00dcberweisung oder einen Dauerauftrag (z.Bsp. mit 1 oder 2 EUR) erstellen, in dem mein Konto bereits als Empf\u00e4nger eingetragen ist.\n\nNur wenn Sie wollen - es ist v\u00f6llig freiwillig.\n\nVielen Dank!\nOlaf Willuhn"), true);
        final char[] iban = new char[]{'D', 'E', '1', '7', '8', '6', '0', '5', '0', '2', '0', '0', '1', '2', '1', '0', '3', '2', '2', '5', '2', '4'};
        final char[] bic = new char[]{'S', 'O', 'L', 'A', 'D', 'E', 'S', '1', 'G', 'R', 'M'};
        String name = "Olaf Willuhn";
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Dauerauftrag erstellen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    SepaDauerauftrag d = (SepaDauerauftrag)Settings.getDBService().createObject(SepaDauerauftrag.class, null);
                    d.setGegenkontoBLZ(new String(bic));
                    d.setGegenkontoNummer(new String(iban));
                    d.setGegenkontoName("Olaf Willuhn");
                    d.setZweck("Hibiscus-Spende");
                    Calendar cal = Calendar.getInstance();
                    cal.add(5, 7);
                    d.setErsteZahlung(cal.getTime());
                    Turnus turnus = (Turnus)Settings.getDBService().createObject(Turnus.class, null);
                    turnus.setIntervall(1);
                    turnus.setTag(cal.get(5));
                    turnus.setZeiteinheit(2);
                    d.setTurnus(turnus);
                    new SepaDauerauftragNew().handleAction(d);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to create sepa-dauerauftrag", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Anlegen des SEPA-Dauerauftrages: {0}", e.getMessage()), 1));
                }
            }
        }, null, false, "emblem-special.png");
        buttons.addButton(i18n.tr("...oder \u00dcberweisung"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    AuslandsUeberweisung u = (AuslandsUeberweisung)Settings.getDBService().createObject(AuslandsUeberweisung.class, null);
                    u.setGegenkontoBLZ(new String(bic));
                    u.setGegenkontoNummer(new String(iban));
                    u.setGegenkontoName("Olaf Willuhn");
                    u.setZweck("Spende Hibiscus");
                    new AuslandsUeberweisungNew().handleAction(u);
                }
                catch (Exception e) {
                    Logger.error((String)"unable to create sepa ueberweisung", (Throwable)e);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Anlegen der SEPA-\u00dcberweisung: {0}", e.getMessage()), 1));
                }
            }
        }, null, false, "ueberweisung.png");
        buttons.paint(this.getParent());
    }
}

