/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.MultiInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TreePart;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.EinnahmeAusgabeExport;
import de.willuhn.jameica.hbci.gui.controller.EinnahmeAusgabeControl;
import de.willuhn.jameica.hbci.gui.parts.EinnahmenAusgabenVerlauf;
import de.willuhn.jameica.hbci.rmi.EinnahmeAusgabeZeitraum;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.TabFolder;

public class EinnahmenAusgaben
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void bind() throws Exception {
        GUI.getView().setTitle(i18n.tr("Einnahmen/Ausgaben"));
        final EinnahmeAusgabeControl control = new EinnahmeAusgabeControl(this);
        TabFolder folder = new TabFolder(this.getParent(), 0);
        folder.setLayoutData((Object)new GridData(768));
        TabGroup tab = new TabGroup(folder, i18n.tr("Anzeige einschr\u00e4nken"));
        ColumnLayout cols = new ColumnLayout(tab.getComposite(), 2);
        SimpleContainer left = new SimpleContainer(cols.getComposite());
        left.addInput(control.getKontoAuswahl());
        left.addInput((Input)control.getInterval());
        left.addInput((Input)control.getActiveOnly());
        SimpleContainer right = new SimpleContainer(cols.getComposite());
        right.addInput((Input)control.getRange());
        MultiInput range = new MultiInput(new Input[]{control.getStart(), control.getEnd()});
        right.addInput((Input)range);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Exportieren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    List data = control.getTree().getItems();
                    new EinnahmeAusgabeExport().handleAction(data.toArray(new EinnahmeAusgabeZeitraum[0]));
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to export data", (Throwable)re);
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Fehler beim Exportieren: {0}", re.getMessage()), 1));
                }
            }
        }, null, false, "document-save.png");
        buttons.addButton(i18n.tr("Aktualisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleReload();
            }
        }, null, true, "view-refresh.png");
        buttons.paint(this.getParent());
        TabFolder folder2 = new TabFolder(this.getParent(), 0);
        TabGroup tg1 = new TabGroup(folder2, i18n.tr("Tabellarische Auswertung"), true, 1);
        TreePart tree = control.getTree();
        tree.paint(tg1.getComposite());
        TabGroup tg2 = new TabGroup(folder2, i18n.tr("Grafische Auswertung"), true, 1);
        EinnahmenAusgabenVerlauf chart = control.getChart();
        chart.paint(tg2.getComposite());
        folder2.setLayoutData((Object)new GridData(1808));
    }
}

