/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.Headline;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.controller.EmpfaengerControl;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.TabFolder;

public class EmpfaengerNew
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void bind() throws Exception {
        GUI.getView().setTitle(i18n.tr("Adresse bearbeiten"));
        final EmpfaengerControl control = new EmpfaengerControl(this);
        ColumnLayout columns = new ColumnLayout(this.getParent(), 2);
        SimpleContainer left = new SimpleContainer(columns.getComposite());
        left.addHeadline(i18n.tr("Nationale Bankverbindung"));
        left.addLabelPair(i18n.tr("Kontoinhaber"), control.getName());
        left.addLabelPair(i18n.tr("Kontonummer"), control.getKontonummer());
        left.addLabelPair(i18n.tr("Bankleitzahl"), control.getBlz());
        left.addHeadline(i18n.tr("Europ\u00e4ische Bankverbindung (SEPA)"));
        left.addLabelPair(i18n.tr("IBAN"), control.getIban());
        left.addLabelPair(i18n.tr("BIC"), control.getBic());
        left.addLabelPair(i18n.tr("Name des Kredit-Instituts"), control.getBank());
        SimpleContainer right = new SimpleContainer(columns.getComposite(), true);
        right.addHeadline(i18n.tr("Notiz"));
        right.addPart((Part)control.getKommentar());
        right.addLabelPair(i18n.tr("Gruppe"), (Input)control.getKategorie());
        ButtonArea buttonArea = new ButtonArea();
        Button delete = new Button(i18n.tr("L\u00f6schen"), (Action)new DBObjectDelete(), (Object)control.getAddress(), false, "user-trash-full.png");
        delete.setEnabled(control.isHibiscusAdresse());
        buttonArea.addButton(delete);
        Button store = new Button(i18n.tr("&Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, true, "document-save.png");
        store.setEnabled(control.isHibiscusAdresse());
        buttonArea.addButton(store);
        buttonArea.paint(this.getParent());
        new Headline(this.getParent(), i18n.tr("Buchungen von/an diese Adresse"));
        TabFolder folder = new TabFolder(this.getParent(), 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        folder.setLayoutData((Object)gd);
        TabGroup tab = new TabGroup(folder, i18n.tr("Ums\u00e4tze"), false, 1);
        control.getUmsatzListe().paint(tab.getComposite());
        TabGroup tab2 = new TabGroup(folder, i18n.tr("\u00dcberweisungen"));
        control.getUeberweisungListe().paint(tab2.getComposite());
        TabGroup tab1 = new TabGroup(folder, i18n.tr("Lastschriften"));
        control.getLastschriftListe().paint(tab1.getComposite());
        TabGroup tab3 = new TabGroup(folder, i18n.tr("Sammellastschriften"));
        control.getSammelLastListe().paint(tab3.getComposite());
        TabGroup tab4 = new TabGroup(folder, i18n.tr("Sammel\u00fcberweisungen"));
        control.getSammelUeberweisungListe().paint(tab4.getComposite());
    }
}

