/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.KontoFetchUmsaetze;
import de.willuhn.jameica.hbci.gui.action.KontoLimitsConfigure;
import de.willuhn.jameica.hbci.gui.action.KontoSyncViaScripting;
import de.willuhn.jameica.hbci.gui.action.KontoauszugList;
import de.willuhn.jameica.hbci.gui.action.UmsatzDetailEdit;
import de.willuhn.jameica.hbci.gui.controller.KontoControl;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.gui.input.KontoInput;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.synchronize.SynchronizeEngine;
import de.willuhn.jameica.hbci.synchronize.jobs.SynchronizeJobKontoauszug;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import javax.annotation.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;

public class KontoNew
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private KontoControl control = new KontoControl(this);
    @Resource
    private SynchronizeEngine synchronizeEngine = null;

    public void bind() throws Exception {
        final Konto k = this.control.getKonto();
        if (k != null && !k.isNewObject()) {
            String s2;
            String s1 = k.getBezeichnung();
            if (s1 == null) {
                s1 = "";
            }
            if ((s2 = k.getKontonummer()) == null) {
                s2 = "";
            }
            GUI.getView().setTitle(i18n.tr("Konto-Details: {0} [Kto.-Nr.: {1}]", new String[]{s1, s2}));
        } else {
            GUI.getView().setTitle(i18n.tr("Konto-Details: Neues Konto"));
        }
        final KontoInput quickSelect = new KontoInput(k, KontoFilter.ALL);
        quickSelect.setName(i18n.tr("Konto wechseln"));
        quickSelect.addListener(new Listener(){

            public void handleEvent(Event event) {
                try {
                    Konto choice = (Konto)quickSelect.getValue();
                    if (choice == null) {
                        return;
                    }
                    if (k.equals((GenericObject)choice)) {
                        return;
                    }
                    new de.willuhn.jameica.hbci.gui.action.KontoNew().handleAction(choice);
                }
                catch (OperationCanceledException choice) {
                }
                catch (ApplicationException ae) {
                    Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(ae.getMessage(), 1));
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to switch konto", (Throwable)re);
                }
            }
        });
        quickSelect.paint(this.getParent());
        TabFolder lf = new TabFolder(this.getParent(), 0);
        lf.setLayoutData((Object)new GridData(768));
        TabGroup props = new TabGroup(lf, i18n.tr("Eigenschaften"));
        ColumnLayout columns = new ColumnLayout(props.getComposite(), 2);
        SimpleContainer left = new SimpleContainer(columns.getComposite());
        left.addLabelPair(i18n.tr("Gruppe"), (Input)this.control.getKategorie());
        left.addLabelPair(i18n.tr("Bezeichnung des Kontos"), this.control.getBezeichnung());
        left.addInput(this.control.getAccountType());
        left.addLabelPair(i18n.tr("Kontoinhaber"), this.control.getName());
        left.addLabelPair(i18n.tr("Saldo"), this.control.getSaldo());
        Input avail = this.control.getSaldoAvailable();
        if (avail != null) {
            left.addLabelPair(i18n.tr("Verf\u00fcgbarer Betrag"), avail);
        }
        SimpleContainer right = new SimpleContainer(columns.getComposite(), true);
        right.addHeadline(i18n.tr("Notizen"));
        right.addPart((Part)this.control.getKommentar());
        TabGroup account = new TabGroup(lf, i18n.tr("Zugangsdaten"));
        ColumnLayout columns2 = new ColumnLayout(account.getComposite(), 2);
        SimpleContainer left2 = new SimpleContainer(columns2.getComposite());
        left2.addLabelPair(i18n.tr("Kundenkennung"), this.control.getKundennummer());
        left2.addLabelPair(i18n.tr("Kontonummer"), this.control.getKontonummer());
        left2.addLabelPair(i18n.tr("Bankleitzahl"), this.control.getBlz());
        left2.addLabelPair(i18n.tr("Unterkontonummer"), this.control.getUnterkonto());
        left2.addInput(this.control.getBackendAuswahl());
        left2.addInput((Input)this.control.getPassportAuswahl());
        right = new SimpleContainer(columns2.getComposite());
        right.addLabelPair(i18n.tr("IBAN"), this.control.getIban());
        right.addLabelPair(i18n.tr("BIC"), this.control.getBic());
        right.addInput((Input)this.control.getOffline());
        ButtonArea buttonArea = new ButtonArea();
        buttonArea.addButton(this.control.getSynchronizeOptions());
        buttonArea.addButton(String.valueOf(i18n.tr("Limits konfigurieren")) + "...", (Action)new KontoLimitsConfigure(), (Object)k, false, "office-chart-area.png");
        buttonArea.addButton(this.control.getProtoButton());
        buttonArea.addButton(this.control.getDelButton());
        buttonArea.addButton(i18n.tr("&Speichern"), o -> this.control.handleStore(), null, false, "document-save.png");
        buttonArea.paint(this.getParent());
        TabFolder folder = new TabFolder(this.getParent(), 0);
        folder.setLayoutData((Object)new GridData(1808));
        TabGroup tab = new TabGroup(folder, i18n.tr("Ums\u00e4tze"), false, 1);
        this.control.getUmsatzList().paint(tab.getComposite());
        TabGroup tab2 = new TabGroup(folder, i18n.tr("Saldo im Verlauf"), false, 1);
        this.control.getSaldoChart().paint(tab2.getComposite());
        ButtonArea buttons = new ButtonArea();
        Button fetch = null;
        Konto konto = this.control.getKonto();
        if (konto.hasFlag(2)) {
            fetch = new Button(i18n.tr("Umsatz anlegen"), (Action)new UmsatzDetailEdit(), (Object)konto, false, "emblem-documents.png");
            if (this.synchronizeEngine.supports(SynchronizeJobKontoauszug.class, konto)) {
                Button sync = new Button(i18n.tr("Saldo und Ums\u00e4tze abrufen"), (Action)new KontoFetchUmsaetze(), (Object)konto, false, "mail-send-receive.png");
                sync.setEnabled(!konto.hasFlag(1));
                buttons.addButton(sync);
            } else {
                Button sync = new Button(i18n.tr("via Scripting synchronisieren"), (Action)new KontoSyncViaScripting(), (Object)konto, false, "mail-send-receive.png");
                sync.setEnabled(!konto.hasFlag(1));
                buttons.addButton(sync);
            }
        } else {
            fetch = new Button(i18n.tr("Saldo und Ums\u00e4tze abrufen"), (Action)new KontoFetchUmsaetze(), (Object)konto, false, "mail-send-receive.png");
        }
        fetch.setEnabled(!konto.hasFlag(1));
        buttons.addButton(fetch);
        buttons.addButton(i18n.tr("Alle Ums\u00e4tze anzeigen"), (Action)new KontoauszugList(), (Object)konto, false, "text-x-generic.png");
        buttons.paint(this.getParent());
    }

    public void reload() throws ApplicationException {
        this.control.handleReload();
        super.reload();
    }

    public void unbind() throws ApplicationException {
        Application.getMessagingFactory().unRegisterMessageConsumer(this.control.getSaldoMessageConsumer());
    }
}

