/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.internal.parts.PanelButtonPrint;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.controller.LastschriftControl;
import de.willuhn.jameica.hbci.io.print.PrintSupportLastschrift;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.Lastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.print.PrintSupport;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class LastschriftNew
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = new MyMessageConsumer();
    private Lastschrift transfer = null;

    public void bind() throws Exception {
        final LastschriftControl control = new LastschriftControl(this);
        this.transfer = (Lastschrift)control.getTransfer();
        GUI.getView().setTitle(i18n.tr("Lastschrift bearbeiten"));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonPrint((PrintSupport)new PrintSupportLastschrift(this.transfer)));
        SimpleContainer c1 = new SimpleContainer(this.getParent());
        c1.addHeadline(i18n.tr("Konto"));
        c1.addInput((Input)control.getKontoAuswahl());
        ColumnLayout cols = new ColumnLayout(this.getParent(), 2);
        SimpleContainer container = new SimpleContainer(cols.getComposite());
        container.addHeadline(i18n.tr("Zahlungspflichtiger"));
        container.addInput((Input)control.getEmpfaengerName());
        container.addInput((Input)control.getEmpfaengerKonto());
        container.addInput((Input)control.getEmpfaengerBlz());
        container.addInput((Input)control.getStoreEmpfaenger());
        container = new SimpleContainer(cols.getComposite());
        container.addHeadline(i18n.tr("Sonstige Informationen"));
        container.addInput(control.getTextSchluessel());
        container.addInput((Input)control.getTermin());
        container.addInput((Input)control.getReminderInterval());
        container = new SimpleContainer(this.getParent());
        container.addHeadline(i18n.tr("Details"));
        container.addInput((Input)control.getZweck());
        container.addInput((Input)control.getZweck2());
        container.addInput(control.getBetrag());
        ButtonArea buttonArea = new ButtonArea();
        buttonArea.addButton(i18n.tr("L\u00f6schen"), (Action)new DBObjectDelete(), (Object)this.transfer, false, "user-trash-full.png");
        Button store = new Button(i18n.tr("Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, !this.transfer.ausgefuehrt(), "document-save.png");
        store.setEnabled(!this.transfer.ausgefuehrt());
        buttonArea.addButton(store);
        buttonArea.paint(this.getParent());
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    public void unbind() throws ApplicationException {
        super.unbind();
        this.transfer = null;
        Application.getMessagingFactory().unRegisterMessageConsumer(this.mc);
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (LastschriftNew.this.transfer == null) {
                return;
            }
            GenericObject o = ((ObjectChangedMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (LastschriftNew.this.transfer.equals(o)) {
                GUI.startView((AbstractView)LastschriftNew.this, (Object)LastschriftNew.this.transfer);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

