/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.internal.parts.PanelButtonPrint;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.Headline;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.controller.SammelLastschriftControl;
import de.willuhn.jameica.hbci.io.print.PrintSupportSammelLastschrift;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.print.PrintSupport;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class SammelLastschriftNew
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = new MyMessageConsumer();
    private SammelTransfer transfer = null;

    public void bind() throws Exception {
        final SammelLastschriftControl control = new SammelLastschriftControl(this);
        this.transfer = control.getTransfer();
        GUI.getView().setTitle(i18n.tr("Sammel-Lastschrift bearbeiten"));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonPrint((PrintSupport)new PrintSupportSammelLastschrift(this.transfer)));
        SimpleContainer group = new SimpleContainer(this.getParent());
        group.addHeadline(i18n.tr("Eigenschaften"));
        group.addLabelPair(i18n.tr("Gutschriftskonto"), (Input)control.getKontoAuswahl());
        group.addLabelPair(i18n.tr("Bezeichnung"), control.getName());
        group.addInput((Input)control.getTermin());
        group.addInput((Input)control.getReminderInterval());
        group.addSeparator();
        group.addLabelPair(i18n.tr("Summe der Buchungen"), control.getSumme());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Sammelauftrag l\u00f6schen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new DBObjectDelete().handleAction(context);
                try {
                    if (SammelLastschriftNew.this.transfer.getID() == null) {
                        control.getBuchungen().removeAll();
                    }
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to remove bookings", (Throwable)re);
                }
            }
        }, (Object)this.transfer, false, "user-trash-full.png");
        Button store = new Button(i18n.tr("Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, !this.transfer.ausgefuehrt(), "document-save.png");
        store.setEnabled(!this.transfer.ausgefuehrt());
        buttons.addButton(store);
        buttons.paint(this.getParent());
        new Headline(this.getParent(), i18n.tr("Enthaltene Buchungen"));
        control.getBuchungen().paint(this.getParent());
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    public void unbind() throws ApplicationException {
        super.unbind();
        this.transfer = null;
        Application.getMessagingFactory().unRegisterMessageConsumer(this.mc);
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (SammelLastschriftNew.this.transfer == null) {
                return;
            }
            GenericObject o = ((ObjectChangedMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (SammelLastschriftNew.this.transfer.equals(o)) {
                GUI.startView((AbstractView)SammelLastschriftNew.this, (Object)SammelLastschriftNew.this.transfer);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

