/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.controller.SammelUeberweisungBuchungControl;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class SammelUeberweisungBuchungNew
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void bind() throws Exception {
        final SammelUeberweisungBuchungControl control = new SammelUeberweisungBuchungControl(this);
        SammelTransfer l = control.getBuchung().getSammelTransfer();
        GUI.getView().setTitle(i18n.tr("Sammel-\u00dcberweisung {0}: Buchung bearbeiten", l.getBezeichnung()));
        SimpleContainer group = new SimpleContainer(this.getParent());
        group.addHeadline(i18n.tr("Empf\u00e4nger"));
        group.addLabelPair(i18n.tr("Name"), (Input)control.getGegenkontoName());
        group.addLabelPair(i18n.tr("Kontonummer"), (Input)control.getGegenKonto());
        group.addLabelPair(i18n.tr("BLZ"), control.getGegenkontoBLZ());
        group.addCheckbox(control.getStoreAddress(), i18n.tr("In Adressbuch \u00fcbernehmen"));
        SimpleContainer details = new SimpleContainer(this.getParent());
        details.addHeadline(i18n.tr("Details"));
        details.addLabelPair(i18n.tr("Verwendungszweck"), control.getZweck());
        details.addLabelPair(i18n.tr("weiterer Verwendungszweck"), (Input)control.getZweck2());
        details.addLabelPair(i18n.tr("Betrag"), control.getBetrag());
        details.addLabelPair(i18n.tr("Textschl\u00fcssel"), (Input)control.getTextSchluessel());
        ButtonArea buttonArea = new ButtonArea();
        Button delete = new Button(i18n.tr("L\u00f6schen"), (Action)new DBObjectDelete(), (Object)control.getBuchung(), false, "user-trash-full.png");
        delete.setEnabled(!l.ausgefuehrt());
        buttonArea.addButton(delete);
        Button store = new Button(i18n.tr("Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore(false);
            }
        }, null, false, "document-save.png");
        store.setEnabled(!l.ausgefuehrt());
        buttonArea.addButton(store);
        Button store2 = new Button(i18n.tr("Speichern und n\u00e4chste Buchung"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore(true);
            }
        }, null, !l.ausgefuehrt(), "go-next.png");
        store2.setEnabled(!l.ausgefuehrt());
        buttonArea.addButton(store2);
        buttonArea.paint(this.getParent());
    }
}

