/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.internal.parts.PanelButtonPrint;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.KontoFetchSepaDauerauftraege;
import de.willuhn.jameica.hbci.gui.action.SepaDauerauftragNew;
import de.willuhn.jameica.hbci.gui.controller.SepaDauerauftragControl;
import de.willuhn.jameica.hbci.io.print.PrintSupportSepaDauerauftrag;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.print.PrintSupport;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SepaDauerauftragList
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = new MyMessageConsumer();

    public void bind() throws Exception {
        SepaDauerauftragControl control = new SepaDauerauftragControl(this);
        final de.willuhn.jameica.hbci.gui.parts.SepaDauerauftragList table = control.getDauerauftragListe();
        final PanelButtonPrint print = new PanelButtonPrint((PrintSupport)new PrintSupportSepaDauerauftrag((Object)table));
        table.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                print.setEnabled(table.getSelection() != null);
            }
        });
        GUI.getView().setTitle(i18n.tr("Vorhandene SEPA-Dauerauftr\u00e4ge"));
        GUI.getView().addPanelButton((PanelButton)print);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("SEPA-Dauerauftr\u00e4ge abrufen..."), (Action)new KontoFetchSepaDauerauftraege(), null, false, "mail-send-receive.png");
        buttons.addButton(i18n.tr("Neuer SEPA-Dauerauftrag"), (Action)new SepaDauerauftragNew(), null, false, "text-x-generic.png");
        buttons.paint(this.getParent());
        table.paint(this.getParent());
        print.setEnabled(table.getSelection() != null);
    }

    public void unbind() throws ApplicationException {
        super.unbind();
        Application.getMessagingFactory().unRegisterMessageConsumer(this.mc);
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            GenericObject o = ((ObjectChangedMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (o instanceof Konto) {
                GUI.startView((AbstractView)SepaDauerauftragList.this, null);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

