/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.internal.parts.PanelButtonPrint;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.SepaDauerauftragDelete;
import de.willuhn.jameica.hbci.gui.controller.SepaDauerauftragControl;
import de.willuhn.jameica.hbci.gui.parts.PanelButtonNew;
import de.willuhn.jameica.hbci.io.print.PrintSupportSepaDauerauftrag;
import de.willuhn.jameica.hbci.rmi.SepaDauerauftrag;
import de.willuhn.jameica.print.PrintSupport;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class SepaDauerauftragNew
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void bind() throws Exception {
        final SepaDauerauftragControl control = new SepaDauerauftragControl(this);
        SepaDauerauftrag da = control.getTransfer();
        GUI.getView().setTitle(i18n.tr("SEPA-Dauerauftrag bearbeiten"));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonNew(SepaDauerauftrag.class));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonPrint((PrintSupport)new PrintSupportSepaDauerauftrag(da)));
        SimpleContainer konten = new SimpleContainer(this.getParent());
        konten.addHeadline(i18n.tr("Konten"));
        konten.addLabelPair(i18n.tr("Pers\u00f6nliches Konto"), control.getKontoAuswahl());
        ColumnLayout columns = new ColumnLayout(this.getParent(), 2);
        SimpleContainer left = new SimpleContainer(columns.getComposite());
        left.addHeadline(i18n.tr("Empf\u00e4nger"));
        left.addLabelPair(i18n.tr("Name"), (Input)control.getEmpfaengerName());
        left.addLabelPair(i18n.tr("IBAN"), (Input)control.getEmpfaengerKonto());
        left.addLabelPair(i18n.tr("BIC"), (Input)control.getEmpfaengerBic());
        left.addInput((Input)control.getStoreEmpfaenger());
        SimpleContainer right = new SimpleContainer(columns.getComposite());
        right.addHeadline(i18n.tr("Turnus"));
        right.addLabelPair(i18n.tr("Zahlungsturnus"), (Input)control.getTurnus());
        right.addLabelPair(i18n.tr("Erste Zahlung"), control.getErsteZahlung());
        right.addLabelPair(i18n.tr("Letzte Zahlung"), control.getLetzteZahlung());
        SimpleContainer details = new SimpleContainer(this.getParent());
        details.addHeadline(i18n.tr("Details"));
        details.addLabelPair(i18n.tr("Verwendungszweck"), (Input)control.getZweck());
        details.addLabelPair(i18n.tr("Betrag"), (Input)control.getBetrag());
        details.addSeparator();
        details.addInput(control.getPurposeCode());
        details.addLabelPair(i18n.tr("Auftragsnummer"), control.getOrderID());
        ButtonArea buttonArea = new ButtonArea();
        String s = i18n.tr("Jetzt ausf\u00fchren...");
        if (da.isActive()) {
            s = i18n.tr("Jetzt aktualisieren...");
        }
        buttonArea.addButton(i18n.tr("L\u00f6schen"), (Action)new SepaDauerauftragDelete(), (Object)da, false, "user-trash-full.png");
        buttonArea.addButton(s, new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleExecute();
            }
        }, null, false, "emblem-important.png");
        buttonArea.addButton(i18n.tr("&Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, true, "document-save.png");
        buttonArea.paint(this.getParent());
    }
}

