/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.internal.parts.PanelButtonPrint;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.action.Duplicate;
import de.willuhn.jameica.hbci.gui.action.SepaLastschriftExecute;
import de.willuhn.jameica.hbci.gui.controller.SepaLastschriftControl;
import de.willuhn.jameica.hbci.gui.parts.PanelButtonNew;
import de.willuhn.jameica.hbci.io.print.PrintSupportSepaLastschrift;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.print.PrintSupport;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;

public class SepaLastschriftNew
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = new MyMessageConsumer();
    private SepaLastschrift transfer = null;

    public void bind() throws Exception {
        final SepaLastschriftControl control = new SepaLastschriftControl(this);
        this.transfer = control.getTransfer();
        GUI.getView().setTitle(i18n.tr("SEPA-Lastschrift bearbeiten"));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonNew(SepaLastschrift.class));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonPrint((PrintSupport)new PrintSupportSepaLastschrift(this.transfer)));
        SimpleContainer cl = new SimpleContainer(this.getParent());
        cl.addHeadline(i18n.tr("Konto"));
        cl.addInput(control.getKontoAuswahl());
        ColumnLayout cols = new ColumnLayout(this.getParent(), 2);
        SimpleContainer container = new SimpleContainer(cols.getComposite());
        container.addHeadline(i18n.tr("Zahlungspflichtiger"));
        container.addLabelPair(i18n.tr("Name"), (Input)control.getEmpfaengerName());
        container.addLabelPair(i18n.tr("IBAN"), (Input)control.getEmpfaengerKonto());
        container.addLabelPair(i18n.tr("BIC"), control.getEmpfaengerBic());
        container.addInput((Input)control.getStoreEmpfaenger());
        container.addHeadline(i18n.tr("SEPA"));
        container.addText(i18n.tr("Bitte beachten Sie die Vorlauffristen."), true);
        container.addInput(control.getType());
        container.addInput(control.getTargetDate());
        container.addInput(control.getEndToEndId());
        container.addInput(control.getPmtInfId());
        container = new SimpleContainer(cols.getComposite());
        container.addHeadline(i18n.tr("Mandat"));
        container.addInput(control.getCreditorId());
        container.addInput(control.getMandateId());
        container.addInput(control.getSignatureDate());
        container.addInput(control.getSequenceType());
        container.addHeadline(i18n.tr("Sonstige Informationen (nur Hibiscus-intern)"));
        container.addText(i18n.tr("Diese Daten werden nicht an die Bank \u00fcbertragen."), true);
        container.addInput((Input)control.getTermin());
        container.addInput((Input)control.getReminderInterval());
        container = new SimpleContainer(this.getParent());
        container.addHeadline(i18n.tr("Details"));
        container.addLabelPair(i18n.tr("Verwendungszweck"), control.getZweck());
        container.addLabelPair(i18n.tr("Betrag"), control.getBetrag());
        ButtonArea buttonArea = new ButtonArea();
        buttonArea.addButton(i18n.tr("L\u00f6schen"), (Action)new DBObjectDelete(), (Object)this.transfer, false, "user-trash-full.png");
        buttonArea.addButton(i18n.tr("Duplizieren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (control.handleStore()) {
                    new Duplicate().handleAction(SepaLastschriftNew.this.transfer);
                }
            }
        }, null, false, "edit-copy.png");
        Button execute = new Button(i18n.tr("Jetzt ausf\u00fchren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (control.handleStore()) {
                    new SepaLastschriftExecute().handleAction(SepaLastschriftNew.this.transfer);
                }
            }
        }, null, false, "emblem-important.png");
        execute.setEnabled(!this.transfer.ausgefuehrt());
        Button store = new Button(i18n.tr("&Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, !this.transfer.ausgefuehrt(), "document-save.png");
        store.setEnabled(!this.transfer.ausgefuehrt());
        buttonArea.addButton(execute);
        buttonArea.addButton(store);
        buttonArea.paint(this.getParent());
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    public void unbind() throws ApplicationException {
        super.unbind();
        this.transfer = null;
        Application.getMessagingFactory().unRegisterMessageConsumer(this.mc);
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (SepaLastschriftNew.this.transfer == null) {
                return;
            }
            GenericObject o = ((ObjectChangedMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (SepaLastschriftNew.this.transfer.equals(o)) {
                GUI.startView((AbstractView)SepaLastschriftNew.this, (Object)SepaLastschriftNew.this.transfer);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

