/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.internal.parts.PanelButtonPrint;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.PanelButton;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.Headline;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.action.Duplicate;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastBuchungNew;
import de.willuhn.jameica.hbci.gui.action.SepaSammelLastschriftExecute;
import de.willuhn.jameica.hbci.gui.controller.SepaSammelLastschriftControl;
import de.willuhn.jameica.hbci.gui.parts.PanelButtonNew;
import de.willuhn.jameica.hbci.io.print.PrintSupportSepaSammelLastschrift;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.MessageConsumer;
import de.willuhn.jameica.print.PrintSupport;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class SepaSammelLastschriftNew
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private MessageConsumer mc = new MyMessageConsumer();
    private SepaSammelLastschrift transfer = null;

    public void bind() throws Exception {
        final SepaSammelLastschriftControl control = new SepaSammelLastschriftControl(this);
        this.transfer = control.getTransfer();
        GUI.getView().setTitle(i18n.tr("SEPA-Sammellastschrift bearbeiten"));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonNew(SepaSammelLastschrift.class));
        GUI.getView().addPanelButton((PanelButton)new PanelButtonPrint((PrintSupport)new PrintSupportSepaSammelLastschrift(this.transfer)));
        SimpleContainer group = new SimpleContainer(this.getParent());
        group.addHeadline(i18n.tr("Eigenschaften"));
        group.addLabelPair(i18n.tr("Gutschriftskonto"), control.getKontoAuswahl());
        group.addLabelPair(i18n.tr("Bezeichnung"), control.getName());
        ColumnLayout cols = new ColumnLayout(this.getParent(), 2);
        SimpleContainer container = new SimpleContainer(cols.getComposite());
        container.addHeadline(i18n.tr("SEPA"));
        container.addText(i18n.tr("Bitte beachten Sie die Vorlauffristen."), true);
        container.addInput(control.getType());
        container.addInput(control.getSequenceType());
        container.addInput(control.getTargetDate());
        container.addInput((Input)control.getBatchBook());
        container.addInput(control.getPmtInfId());
        container = new SimpleContainer(cols.getComposite());
        container.addHeadline(i18n.tr("Sonstige Informationen (nur Hibiscus-intern)"));
        container.addText(i18n.tr("Diese Daten werden nicht an die Bank \u00fcbertragen."), true);
        container.addInput((Input)control.getTermin());
        container.addInput((Input)control.getReminderInterval());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Sammelauftrag l\u00f6schen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                new DBObjectDelete().handleAction(context);
                try {
                    if (SepaSammelLastschriftNew.this.transfer.getID() == null) {
                        control.getBuchungen().removeAll();
                    }
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to remove bookings", (Throwable)re);
                }
            }
        }, (Object)this.transfer, false, "user-trash-full.png");
        buttons.addButton(i18n.tr("Duplizieren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (control.handleStore()) {
                    new Duplicate().handleAction(SepaSammelLastschriftNew.this.transfer);
                }
            }
        }, null, false, "edit-copy.png");
        Button add = new Button(i18n.tr("Neue Buchungen hinzuf\u00fcgen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (control.handleStore()) {
                    new SepaSammelLastBuchungNew().handleAction(SepaSammelLastschriftNew.this.transfer);
                }
            }
        }, null, false, "text-x-generic.png");
        add.setEnabled(!this.transfer.ausgefuehrt());
        Button execute = new Button(i18n.tr("Jetzt ausf\u00fchren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (control.handleStore()) {
                    new SepaSammelLastschriftExecute().handleAction(SepaSammelLastschriftNew.this.transfer);
                }
            }
        }, null, false, "emblem-important.png");
        execute.setEnabled(!this.transfer.ausgefuehrt());
        Button store = new Button(i18n.tr("&Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, !this.transfer.ausgefuehrt(), "document-save.png");
        store.setEnabled(!this.transfer.ausgefuehrt());
        buttons.addButton(add);
        buttons.addButton(execute);
        buttons.addButton(store);
        buttons.paint(this.getParent());
        new Headline(this.getParent(), i18n.tr("Enthaltene Buchungen"));
        control.getBuchungen().paint(this.getParent());
        Application.getMessagingFactory().registerMessageConsumer(this.mc);
    }

    public void unbind() throws ApplicationException {
        super.unbind();
        this.transfer = null;
        Application.getMessagingFactory().unRegisterMessageConsumer(this.mc);
    }

    private class MyMessageConsumer
    implements MessageConsumer {
        private MyMessageConsumer() {
        }

        public Class[] getExpectedMessageTypes() {
            return new Class[]{ObjectChangedMessage.class};
        }

        public void handleMessage(Message message) throws Exception {
            if (SepaSammelLastschriftNew.this.transfer == null) {
                return;
            }
            GenericObject o = ((ObjectChangedMessage)message).getObject();
            if (o == null) {
                return;
            }
            if (SepaSammelLastschriftNew.this.transfer.equals(o)) {
                GUI.startView((AbstractView)SepaSammelLastschriftNew.this, (Object)SepaSammelLastschriftNew.this.transfer);
            }
        }

        public boolean autoRegister() {
            return false;
        }
    }
}

