/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.extension.Extendable;
import de.willuhn.jameica.gui.input.CheckboxInput;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.CustomRangeEdit;
import de.willuhn.jameica.hbci.gui.action.UmsatzTypNew;
import de.willuhn.jameica.hbci.gui.controller.SettingsControl;
import de.willuhn.jameica.hbci.server.Range;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.TabFolder;

public class Settings
extends AbstractView
implements Extendable {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static Integer lastActiveTab = null;
    private TabFolder folder = null;

    public void bind() throws Exception {
        GUI.getView().setTitle(i18n.tr("Einstellungen"));
        final SettingsControl control = new SettingsControl(this);
        TabGroup system = new TabGroup(this.getTabFolder(), i18n.tr("Grundeinstellungen"));
        system.addHeadline(i18n.tr("Sicherheit"));
        system.addCheckbox(control.getCachePin(), i18n.tr("PIN-Eingaben f\u00fcr die aktuelle Sitzung zwischenspeichern"));
        system.addCheckbox(control.getStorePin(), i18n.tr("PIN-Eingaben permanent speichern (nur bei PIN/TAN)"));
        system.addHeadline(i18n.tr("Kontrolle"));
        system.addCheckbox(control.getKontoCheck(), i18n.tr("Kontonummern und Bankleitzahlen mittels Pr\u00fcfsumme testen"));
        system.addCheckbox(control.getKontoCheckExcludeAddressbook(), i18n.tr("Au\u00dfer Bankverbindungen des Adressbuches"));
        system.addLabelPair(i18n.tr("Limit f\u00fcr Auftr\u00e4ge"), control.getUeberweisungLimit());
        TabGroup myema = new TabGroup(this.getTabFolder(), i18n.tr("Myema"));
        myema.addLabelPair(i18n.tr("ServerURL"), control.getServerURL());
        myema.addLabelPair(i18n.tr("Benutzername"), control.getUserName());
        myema.addLabelPair(i18n.tr("Kennwort"), control.getPassword());
        myema.addLabelPair(i18n.tr("BezirksID"), control.getBezirksID());
        myema.addLabelPair(i18n.tr("Buchungsjahr"), control.getBuchungsJahr());
        TabGroup ui = new TabGroup(this.getTabFolder(), i18n.tr("Benutzeroberfl\u00e4che"));
        ui.addHeadline(i18n.tr("Farben"));
        ui.addLabelPair(i18n.tr("Textfarbe von Sollbuchungen"), control.getBuchungSollForeground());
        ui.addLabelPair(i18n.tr("Textfarbe von Habenbuchungen"), control.getBuchungHabenForeground());
        ui.addCheckbox(control.getColorValues(), i18n.tr("Nur Geld-Betr\u00e4ge farbig anzeigen"));
        ui.addHeadline(i18n.tr("Formatierung"));
        ui.addCheckbox(control.getDecimalGrouping(), i18n.tr("Tausender-Trennzeichen bei Geld-Betr\u00e4gen anzeigen"));
        ui.addCheckbox(control.getBoldValues(), i18n.tr("Geld-Betr\u00e4ge fett gedruckt anzeigen"));
        TabGroup umsatztypes = new TabGroup(this.getTabFolder(), i18n.tr("Umsatz-Kategorien"));
        control.getUmsatzTypTree().paint(umsatztypes.getComposite());
        ButtonArea umsatzButtons = new ButtonArea();
        umsatzButtons.addButton(i18n.tr("Neue Umsatz-Kategorie..."), (Action)new UmsatzTypNew(), null, false, "text-x-generic.png");
        umsatztypes.addButtonArea(umsatzButtons);
        TabGroup ranges = new TabGroup(this.getTabFolder(), i18n.tr("Zeitr\u00e4ume"), true, 1);
        ranges.addText(i18n.tr("W\u00e4hlen Sie f\u00fcr die verschiedenen Bereiche der Anwendung aus, welche Zeitraum-Vorauswahlen angezeigt werden sollen."), true);
        Range.Category[] categoryArray = Range.Category.values();
        int n = categoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            Range.Category cat = categoryArray[n2];
            ranges.addHeadline(cat.getName());
            ranges.addPart((Part)control.getRanges(cat));
            ButtonArea rb = new ButtonArea();
            rb.addButton(i18n.tr("Neuer Zeitraum..."), (Action)new CustomRangeEdit(cat), null, false, "document-new.png");
            rb.paint(ranges.getComposite());
            ++n2;
        }
        TabGroup extended = new TabGroup(this.getTabFolder(), "Erweitert", true);
        extended.addHeadline(i18n.tr("Experimentelle Funktionen"));
        extended.addText(String.valueOf(i18n.tr("Wenn die experimentellen Funktionen nicht aktiviert sind, gelten die Vorgabewerte.")) + "\n", true);
        extended.addInput((Input)control.getExFeatures());
        extended.addSeparator();
        for (CheckboxInput c : control.getExperiments()) {
            extended.addInput((Input)c);
            extended.addText(String.valueOf((String)c.getData("description")) + "\n", true, Color.COMMENT);
        }
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("&Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, true, "document-save.png");
        buttons.paint(this.getParent());
        if (lastActiveTab != null) {
            this.getTabFolder().setSelection(lastActiveTab.intValue());
        }
    }

    public TabFolder getTabFolder() {
        if (this.folder != null) {
            return this.folder;
        }
        this.folder = new TabFolder(this.getParent(), 0);
        this.folder.setLayoutData((Object)new GridData(1808));
        return this.folder;
    }

    public void unbind() throws ApplicationException {
        lastActiveTab = this.getTabFolder().getSelectionIndex();
    }

    public String getExtendableID() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

