/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.Part;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.DBObjectDelete;
import de.willuhn.jameica.hbci.gui.action.Duplicate;
import de.willuhn.jameica.hbci.gui.controller.UmsatzTypControl;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public class UmsatzTypDetail
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void bind() throws Exception {
        final UmsatzTypControl control = new UmsatzTypControl(this);
        GUI.getView().setTitle(i18n.tr("Umsatz-Kategorie"));
        ColumnLayout columns = new ColumnLayout(this.getParent(), 2);
        SimpleContainer left = new SimpleContainer(columns.getComposite());
        left.addHeadline(i18n.tr("Eigenschaften"));
        left.addLabelPair(i18n.tr("Bezeichnung"), (Input)control.getName());
        left.addLabelPair(i18n.tr("\u00dcbergeordnete Kategorie"), (Input)control.getParent());
        left.addHeadline(i18n.tr("Zuordnung der Ums\u00e4tze"));
        left.addInput((Input)control.getKonto());
        left.addLabelPair(i18n.tr("Reihenfolge"), (Input)control.getNummer());
        left.addLabelPair(i18n.tr("Art des Umsatzes"), (Input)control.getArt());
        left.addLabelPair(i18n.tr("Suchbegriff"), (Input)control.getPattern());
        left.addCheckbox(control.getRegex(), i18n.tr("Suchbegriff ist ein regul\u00e4rer Ausdruck"));
        SimpleContainer right = new SimpleContainer(columns.getComposite(), true);
        right.addHeadline(i18n.tr("Notizen"));
        right.addPart((Part)control.getKommentar());
        right.addHeadline(i18n.tr("Darstellung"));
        right.addInput((Input)control.getSkipReport());
        right.addCheckbox(control.getCustomColor(), i18n.tr("Benutzerdefinierte Farbe"));
        right.addLabelPair(i18n.tr("Farbe"), (Input)control.getColor());
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("L\u00f6schen"), (Action)new DBObjectDelete(), control.getCurrentObject(), false, "user-trash-full.png");
        buttons.addButton(i18n.tr("Duplizieren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                if (control.handleStore()) {
                    try {
                        new Duplicate().handleAction(control.getUmsatzTyp());
                    }
                    catch (RemoteException re) {
                        Logger.error((String)"unable to duplicate data", (Throwable)re);
                        throw new ApplicationException(i18n.tr("Duplizieren fehlgeschlagen: {0}", re.getMessage()));
                    }
                }
            }
        }, null, false, "edit-copy.png");
        buttons.addButton(i18n.tr("&Speichern"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleStore();
            }
        }, null, true, "document-save.png");
        buttons.paint(this.getParent());
    }
}

