/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.gui.views;

import de.willuhn.jameica.gui.AbstractView;
import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.gui.input.Input;
import de.willuhn.jameica.gui.input.MultiInput;
import de.willuhn.jameica.gui.input.TextInput;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TreePart;
import de.willuhn.jameica.gui.util.ColumnLayout;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.gui.util.TabGroup;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.action.UmsatzTypTreeExport;
import de.willuhn.jameica.hbci.gui.controller.UmsatzTypTreeControl;
import de.willuhn.jameica.hbci.gui.parts.UmsatzTypVerlauf;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;

public class UmsatzTypTree
extends AbstractView {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    public void bind() throws Exception {
        GUI.getView().setTitle(i18n.tr("Ums\u00e4tze nach Kategorien"));
        final UmsatzTypTreeControl control = new UmsatzTypTreeControl(this);
        TabFolder folder = new TabFolder(this.getParent(), 0);
        folder.setLayoutData((Object)new GridData(768));
        TabGroup tab = new TabGroup(folder, i18n.tr("Anzeige einschr\u00e4nken"));
        ColumnLayout cols = new ColumnLayout(tab.getComposite(), 2);
        SimpleContainer left = new SimpleContainer(cols.getComposite());
        left.addInput(control.getKontoAuswahl());
        TextInput t = control.getText();
        left.addInput((Input)t);
        final Listener l = control.changedListener((Input)t);
        t.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                l.handleEvent(null);
            }
        });
        SimpleContainer right = new SimpleContainer(cols.getComposite());
        right.addInput((Input)control.getRange());
        MultiInput range = new MultiInput(new Input[]{control.getStart(), control.getEnd()});
        right.addInput((Input)range);
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(i18n.tr("Alle aufklappen/zuklappen"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleExpand();
            }
        }, null, false, "folder.png");
        buttons.addButton(i18n.tr("Exportieren..."), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                try {
                    new UmsatzTypTreeExport().handleAction(control.getUmsatzTree());
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to load umsatz tree", (Throwable)re);
                    throw new ApplicationException(i18n.tr("Fehler beim Laden der Ums\u00e4tze"), (Throwable)re);
                }
            }
        }, null, false, "document-save.png");
        buttons.addButton(i18n.tr("Aktualisieren"), new Action(){

            public void handleAction(Object context) throws ApplicationException {
                control.handleReload();
            }
        }, null, true, "view-refresh.png");
        buttons.paint(this.getParent());
        final TabFolder folder2 = new TabFolder(this.getParent(), 0);
        folder2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (folder2.getSelectionIndex() == 1) {
                    control.handleRefreshChart();
                }
            }
        });
        folder2.setLayoutData((Object)new GridData(1808));
        TabGroup tg1 = new TabGroup(folder2, i18n.tr("Tabellarisch"), true, 1);
        TreePart tree = control.getTree();
        tree.paint(tg1.getComposite());
        TabGroup tg2 = new TabGroup(folder2, i18n.tr("Im Verlauf"), true, 1);
        UmsatzTypVerlauf chart = control.getChart();
        chart.paint(tg2.getComposite());
    }
}

