/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.IO;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.rmi.SammelTransferBuchung;
import de.willuhn.jameica.hbci.rmi.SammelUeberweisungBuchung;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;

public abstract class AbstractDTAUSIO
implements IO {
    static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public String getName() {
        return i18n.tr("DTAUS-Format");
    }

    protected int mapTextschluesselToDtaus(SammelTransferBuchung buchung) throws RemoteException {
        if (buchung == null) {
            return 51000;
        }
        int ts = buchung instanceof SammelUeberweisungBuchung ? 51000 : 5000;
        String textschluessel = buchung.getTextSchluessel();
        if (textschluessel != null) {
            if (textschluessel.equals("04")) {
                ts = 4000;
            } else if (textschluessel.equals("53")) {
                ts = 53000;
            }
        }
        return ts;
    }

    protected String mapDtausToTextschluessel(SammelTransferBuchung buchung, long ts) {
        if (ts == 4000L) {
            return "04";
        }
        if (ts == 53000L) {
            return "53";
        }
        return buchung instanceof SammelUeberweisungBuchung ? "51" : "05";
    }

    abstract Class[] getSupportedObjectTypes();

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (objectType == null) {
            return null;
        }
        Class[] supported = this.getSupportedObjectTypes();
        if (supported == null || supported.length == 0) {
            return null;
        }
        int i = 0;
        while (i < supported.length) {
            if (objectType.equals(supported[i])) {
                return new IOFormat[]{new MyIOFormat(objectType)};
            }
            ++i;
        }
        return null;
    }

    class MyIOFormat
    implements IOFormat {
        Class type = null;

        private MyIOFormat(Class type) {
            this.type = type;
        }

        @Override
        public String getName() {
            return AbstractDTAUSIO.this.getName();
        }

        @Override
        public String[] getFileExtensions() {
            return new String[]{"*.dta"};
        }
    }
}

