/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.Closeable;
import java.io.OutputStream;
import java.rmi.RemoteException;

public abstract class AbstractExporter
implements Exporter {
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        try {
            try {
                this.setup(objects, format, os, monitor);
                double factor = (double)(100 - monitor.getPercentComplete()) / (double)objects.length;
                monitor.setStatusText(i18n.tr("Exportiere Daten"));
                int i = 0;
                while (i < objects.length) {
                    monitor.setPercentComplete((int)((double)i * factor));
                    monitor.log(i18n.tr("Speichere Datensatz {0}", Integer.toString(i + 1)));
                    this.exportObject(objects[i], i, os);
                    ++i;
                }
                this.commit(objects, format, os, monitor);
                Application.getMessagingFactory().sendMessage((Message)new StatusBarMessage(i18n.tr("Daten exportiert"), 0));
            }
            catch (OperationCanceledException | ApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.error((String)"unable to export data", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Export der Daten: {0}", e.getMessage()), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{os});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{os});
    }

    void setup(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws Exception {
        if (objects == null || objects.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Daten aus"));
        }
    }

    void commit(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws Exception {
    }

    abstract void exportObject(Object var1, int var2, OutputStream var3) throws Exception;

    abstract Class[] getSupportedObjectTypes();

    abstract String[] getFileExtensions();

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (objectType == null) {
            return null;
        }
        Class[] supported = this.getSupportedObjectTypes();
        if (supported == null || supported.length == 0) {
            return null;
        }
        int i = 0;
        while (i < supported.length) {
            if (objectType.equals(supported[i])) {
                return new IOFormat[]{new MyIOFormat(objectType)};
            }
            ++i;
        }
        return null;
    }

    @Override
    public boolean suppportsExtension(String ext) {
        return false;
    }

    class MyIOFormat
    implements IOFormat {
        Class type = null;

        private MyIOFormat(Class type) {
            this.type = type;
        }

        @Override
        public String getName() {
            return AbstractExporter.this.getName();
        }

        @Override
        public String[] getFileExtensions() {
            return AbstractExporter.this.getFileExtensions();
        }
    }
}

