/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Importer;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.Closeable;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractImporter
implements Importer {
    static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void doImport(Object context, IOFormat format, InputStream is, ProgressMonitor monitor, BackgroundTask t) throws RemoteException, ApplicationException {
        try {
            try {
                Object[] objects = this.setup(context, format, is, monitor);
                HashMap ctx = new HashMap();
                double factor = (double)(100 - monitor.getPercentComplete()) / (double)objects.length;
                monitor.setStatusText(i18n.tr("Importiere Daten"));
                int success = 0;
                int failed = 0;
                int i = 0;
                while (i < objects.length) {
                    if (t != null && t.isInterrupted()) {
                        throw new OperationCanceledException();
                    }
                    monitor.setPercentComplete((int)((double)i * factor));
                    monitor.log(i18n.tr("Lese Datensatz {0}", Integer.toString(i + 1)));
                    try {
                        this.importObject(objects[i], i, ctx);
                        ++success;
                    }
                    catch (Exception e) {
                        String msg = e.getMessage();
                        monitor.log("  " + i18n.tr("  Import fehlgeschlagen: {0}", msg != null ? msg : e.getClass().getSimpleName()));
                        monitor.log("  " + i18n.tr("  Fehlerhafter Datensatz: {0}", BeanUtil.toString((Object)objects[i])));
                        ++failed;
                    }
                    ++i;
                }
                this.commit(objects, format, is, monitor);
                monitor.log(i18n.tr("{0} importiert, {1} fehlerhaft", new String[]{Integer.toString(success), Integer.toString(failed)}));
            }
            catch (OperationCanceledException | ApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.error((String)"unable to import data", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Import der Daten: {0}", e.getMessage()), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{is});
    }

    abstract Object[] setup(Object var1, IOFormat var2, InputStream var3, ProgressMonitor var4) throws Exception;

    void commit(Object[] objects, IOFormat format, InputStream is, ProgressMonitor monitor) throws Exception {
    }

    abstract void importObject(Object var1, int var2, Map var3) throws Exception;

    abstract Class[] getSupportedObjectTypes();

    abstract String[] getFileExtensions();

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (objectType == null) {
            return null;
        }
        Class[] supported = this.getSupportedObjectTypes();
        if (supported == null || supported.length == 0) {
            return null;
        }
        int i = 0;
        while (i < supported.length) {
            if (objectType.equals(supported[i])) {
                return new IOFormat[]{new MyIOFormat(objectType)};
            }
            ++i;
        }
        return null;
    }

    class MyIOFormat
    implements IOFormat {
        Class type = null;

        private MyIOFormat(Class type) {
            this.type = type;
        }

        @Override
        public String getName() {
            return AbstractImporter.this.getName();
        }

        @Override
        public String[] getFileExtensions() {
            return AbstractImporter.this.getFileExtensions();
        }
    }
}

