/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfPCell;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Reporter;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractPDFUmsatzExporter<T extends GenericObject>
implements Exporter {
    private static Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        if (objects == null || objects.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Ums\u00e4tze aus"));
        }
        Umsatz first = (Umsatz)objects[0];
        Date startDate = first.getDatum();
        Date endDate = first.getDatum();
        HashMap<String, List> umsaetze = new HashMap<String, List>();
        if (monitor != null) {
            monitor.setStatusText(i18n.tr("Ermittle zu exportierende Ums\u00e4tze und Konten"));
            monitor.addPercentComplete(1);
        }
        HashMap<String, T> groupMap = new HashMap<String, T>();
        int i = 0;
        while (i < objects.length) {
            T group;
            Umsatz u = (Umsatz)objects[i];
            Date date = u.getDatum();
            if (date != null) {
                if (endDate != null && date.after(endDate)) {
                    endDate = date;
                }
                if (startDate != null && date.before(startDate)) {
                    startDate = date;
                }
            }
            String key = (group = this.getGroup(u)) != null ? group.getID() : null;
            groupMap.put(key, group);
            List list = umsaetze.computeIfAbsent(key, k -> new ArrayList());
            list.add(u);
            ++i;
        }
        Date d = (Date)Exporter.SESSION.get((Object)"pdf.start");
        if (d != null) {
            startDate = d;
        }
        if ((d = (Date)Exporter.SESSION.get((Object)"pdf.end")) != null) {
            endDate = d;
        }
        Boolean filter = (Boolean)Exporter.SESSION.get((Object)"filtered");
        Boolean b = (Boolean)Exporter.SESSION.get((Object)"saldo.show");
        boolean showSaldo = b == null || b != false;
        b = (Boolean)Exporter.SESSION.get((Object)"sumrow.add");
        boolean addSumRow = b != null && b != false;
        boolean fullUsage = settings.getBoolean("usage.display.all", true);
        Reporter reporter = null;
        try {
            try {
                String subTitle = i18n.tr("{0} - {1}", new String[]{startDate == null ? "" : HBCI.DATEFORMAT.format(startDate), endDate == null ? "" : HBCI.DATEFORMAT.format(endDate)});
                reporter = new Reporter(os, monitor, String.valueOf(i18n.tr("Ums\u00e4tze")) + (filter != null && filter != false ? " (" + i18n.tr("gefiltert") + ")" : ""), subTitle, objects.length);
                reporter.addHeaderColumn(i18n.tr("Valuta / Buchungsdatum"), 1, 30, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Empf\u00e4nger/Einzahler"), 1, 100, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Zahlungsgrund"), 1, 120, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Betrag"), 1, 30, Reporter.COLOR_BG);
                if (showSaldo) {
                    reporter.addHeaderColumn(i18n.tr("Saldo"), 1, 30, Reporter.COLOR_BG);
                }
                reporter.createHeader();
                Double sumOverall = 0.0;
                ArrayList groupList = new ArrayList(groupMap.values());
                this.sort(groupList);
                for (GenericObject group : groupList) {
                    Double sumRow = 0.0;
                    PdfPCell cell = reporter.getDetailCell(this.toString(group), 1, Reporter.COLOR_BG);
                    cell.setColspan(showSaldo ? 5 : 4);
                    reporter.addColumn(cell);
                    List list = (List)umsaetze.get(group != null ? group.getID() : null);
                    if (list.size() == 0) {
                        PdfPCell empty = reporter.getDetailCell(i18n.tr("Keine Ums\u00e4tze"), 1, Reporter.COLOR_BG);
                        empty.setColspan(5);
                        reporter.addColumn(empty);
                        continue;
                    }
                    for (Umsatz u : list) {
                        String art;
                        String iban;
                        String valuta = u.getValuta() != null ? HBCI.DATEFORMAT.format(u.getValuta()) : "";
                        String datum = u.getDatum() != null ? HBCI.DATEFORMAT.format(u.getDatum()) : "";
                        BaseColor color = null;
                        int style = 0;
                        if (u.hasFlag(2)) {
                            color = Reporter.COLOR_GRAY;
                            style = 2;
                        }
                        String name = reporter.notNull(u.getGegenkontoName());
                        String name2 = reporter.notNull(u.getGegenkontoName2());
                        if (name.length() > 0 && name2.length() > 0) {
                            name = String.valueOf(name) + "\n" + name2;
                        }
                        if ((iban = u.getGegenkontoNummer()) != null && iban.length() > 0) {
                            name = String.valueOf(name) + "\n" + HBCIProperties.formatIban(iban);
                            String bic = u.getGegenkontoBLZ();
                            if (bic != null && bic.length() > 0 && (bic = HBCIProperties.getNameForBank(bic)) != null) {
                                name = String.valueOf(name) + "\n" + bic;
                            }
                        }
                        if ((art = u.getArt()) != null && art.length() > 0) {
                            name = String.valueOf(name) + "\n" + art;
                        }
                        reporter.addColumn(reporter.getDetailCell(String.valueOf(valuta) + "\n" + datum, 0, null, color, style));
                        reporter.addColumn(reporter.getDetailCell(reporter.notNull(name), 0, null, color, style));
                        String verwendungszweck = fullUsage ? VerwendungszweckUtil.toString(u, "\n") : VerwendungszweckUtil.getTag(u, VerwendungszweckUtil.Tag.SVWZ);
                        String comment = u.getKommentar();
                        if (comment != null && comment.length() > 0) {
                            verwendungszweck = String.valueOf(verwendungszweck) + "\n" + i18n.tr("Notiz") + ": " + comment;
                        }
                        reporter.addColumn(reporter.getDetailCell(verwendungszweck, 0, null, color, style));
                        reporter.addColumn(reporter.getDetailCell(u.getBetrag()));
                        sumRow = sumRow + u.getBetrag();
                        if (showSaldo) {
                            reporter.addColumn(reporter.getDetailCell(u.getSaldo()));
                        }
                        reporter.setNextRecord();
                    }
                    if (addSumRow) {
                        reporter.addColumn(reporter.getDetailCell(null, 0));
                        reporter.addColumn(reporter.getDetailCell(i18n.tr("Summe"), 0, null, null, 1));
                        reporter.addColumn(reporter.getDetailCell(null, 0));
                        reporter.addColumn(reporter.getDetailCell(sumRow, null, 1));
                        if (showSaldo) {
                            reporter.addColumn(reporter.getDetailCell(null, 0));
                        }
                    }
                    sumOverall = sumOverall + sumRow;
                }
                if (addSumRow) {
                    reporter.addColumn(reporter.getDetailCell(null, 0));
                    reporter.addColumn(reporter.getDetailCell(i18n.tr("Gesamtsumme"), 0, null, null, 1));
                    reporter.addColumn(reporter.getDetailCell(null, 0));
                    reporter.addColumn(reporter.getDetailCell(sumOverall, null, 1));
                    if (showSaldo) {
                        reporter.addColumn(reporter.getDetailCell(null, 0));
                    }
                }
                if (monitor != null) {
                    monitor.setStatus(4);
                }
            }
            catch (Exception e) {
                if (monitor != null) {
                    monitor.setStatus(3);
                }
                Logger.error((String)"error while creating report", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Erzeugen der Auswertung"), (Throwable)e);
            }
        }
        finally {
            if (reporter != null) {
                try {
                    reporter.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close report", (Throwable)e);
                }
            }
        }
    }

    protected abstract T getGroup(Umsatz var1) throws RemoteException;

    protected void sort(List<T> groups) throws RemoteException {
    }

    protected abstract String toString(T var1) throws RemoteException;

    @Override
    public boolean suppportsExtension(String ext) {
        return ext != null && ("sumrow.add".equals(ext) || "saldo.show".equals(ext));
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (!Umsatz.class.equals((Object)objectType)) {
            return null;
        }
        IOFormat format = new IOFormat(){

            @Override
            public String getName() {
                return AbstractPDFUmsatzExporter.this.getName();
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"pdf"};
            }
        };
        return new IOFormat[]{format};
    }
}

