/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.gui.dialogs.PainVersionDialog;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.io.AbstractExporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.rmi.HibiscusTransfer;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.logging.Logger;
import de.willuhn.util.ProgressMonitor;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.generators.ISEPAGenerator;
import org.kapott.hbci.GV.generators.SEPAGeneratorFactory;
import org.kapott.hbci.sepa.SepaVersion;

public abstract class AbstractSepaExporter
extends AbstractExporter {
    private static final String SYSPROP_FORMATTED = "sepa.pain.formatted";
    private Map<OutputStream, JobContext> jobs = Collections.synchronizedMap(new HashMap());

    @Override
    public String getName() {
        return i18n.tr("SEPA-XML");
    }

    @Override
    String[] getFileExtensions() {
        return new String[]{"*.xml"};
    }

    @Override
    void setup(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws Exception {
        Konto konto;
        super.setup(objects, format, os, monitor);
        HashSet<String> ids = new HashSet<String>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Konto k = this.getKonto(o);
            if (k == null) {
                Logger.warn((String)("unable to determine konto for object " + o));
            } else {
                ids.add(k.getID());
                if (ids.size() > 1) break;
            }
            ++n2;
        }
        if (ids.size() > 1) {
            KontoAuswahlDialog d = new KontoAuswahlDialog(null, KontoFilter.FOREIGN, 1);
            d.setText(i18n.tr("Die Auftr\u00e4ge sind unterschiedlichen Konten zugeordnet.\nEine SEPA XML-Datei kann jedoch nur Auftr\u00e4ge eines Kontos enthalten.\n\nBitte w\u00e4hlen Sie das Konto, dem die Auftr\u00e4ge in der XML-Datei\nzugeordnet werden sollen"));
            konto = (Konto)d.open();
        } else {
            konto = this.getKonto(objects[0]);
        }
        JobContext ctx = new JobContext();
        this.jobs.put(os, ctx);
        PainVersionDialog d = new PainVersionDialog(this.getPainType());
        ctx.version = (SepaVersion)d.open();
        ctx.props.setProperty("src.bic", StringUtils.trimToEmpty((String)konto.getBic()));
        ctx.props.setProperty("src.iban", StringUtils.trimToEmpty((String)konto.getIban()));
        ctx.props.setProperty("src.name", StringUtils.trimToEmpty((String)konto.getName()));
        ctx.props.setProperty("sepaid", Long.toString(System.currentTimeMillis()));
    }

    @Override
    void commit(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws Exception {
        String backup = System.getProperty(SYSPROP_FORMATTED);
        try {
            System.setProperty(SYSPROP_FORMATTED, "true");
            JobContext ctx = this.jobs.get(os);
            ISEPAGenerator gen = SEPAGeneratorFactory.get((String)this.getJobName(), (SepaVersion)ctx.version);
            gen.generate((Object)ctx.props, os, false);
        }
        finally {
            if (backup != null) {
                System.setProperty(SYSPROP_FORMATTED, backup);
            } else {
                System.clearProperty(SYSPROP_FORMATTED);
            }
            this.jobs.remove(os);
            super.commit(objects, format, os, monitor);
        }
    }

    @Override
    void exportObject(Object o, int idx, OutputStream os) throws Exception {
        this.exportObject(o, idx, this.jobs.get(os));
    }

    private Konto getKonto(Object o) throws Exception {
        if (o instanceof HibiscusTransfer) {
            return ((HibiscusTransfer)o).getKonto();
        }
        if (o instanceof SepaSammelTransfer) {
            return ((SepaSammelTransfer)o).getKonto();
        }
        return null;
    }

    protected abstract void exportObject(Object var1, int var2, JobContext var3) throws Exception;

    protected abstract SepaVersion.Type getPainType();

    protected abstract String getJobName();

    protected class JobContext {
        protected SepaVersion version = null;
        protected Properties props = new Properties();
        protected Map meta = new HashMap();

        protected JobContext() {
        }
    }
}

