/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.io.IOUtil;
import de.willuhn.jameica.gui.dialogs.YesNoDialog;
import de.willuhn.jameica.gui.util.SWTUtil;
import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.gui.filter.KontoFilter;
import de.willuhn.jameica.hbci.io.AbstractImporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.sepa.SepaVersion;

public abstract class AbstractSepaImporter
extends AbstractImporter {
    private Map<String, Konto> kontenCache = new HashMap<String, Konto>();

    @Override
    public String getName() {
        return i18n.tr("SEPA-XML");
    }

    @Override
    String[] getFileExtensions() {
        return new String[]{"*.xml"};
    }

    @Override
    Object[] setup(Object context, IOFormat format, InputStream is, ProgressMonitor monitor) throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtil.copy((InputStream)is, (OutputStream)bos);
        SepaVersion version = SepaVersion.autodetect((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        if (version == null) {
            throw new ApplicationException(i18n.tr("SEPA-Version der XML-Datei nicht ermittelbar"));
        }
        monitor.log(i18n.tr("SEPA-Version: {0}", version.getURN()));
        SepaVersion.Type type = this.getSupportedPainType();
        if (type != null && type != version.getType()) {
            boolean b = type == SepaVersion.Type.PAIN_001;
            String l = i18n.tr("Lastschrift");
            String u = i18n.tr("\u00dcberweisung");
            String q = i18n.tr("Sie versuchen, eine {0} als {1} zu importieren.\nVorgang wirklich fortsetzen?", new String[]{b ? l : u, b ? u : l});
            YesNoDialog d = new YesNoDialog(1);
            d.setTitle(i18n.tr("Warnung"));
            d.setSideImage(SWTUtil.getImage((String)"dialog-warning-large.png"));
            d.setText("\n" + q + "\n");
            b = (Boolean)d.open();
            if (!b) {
                throw new OperationCanceledException();
            }
        }
        ArrayList props = new ArrayList();
        ISEPAParser parser = SEPAParserFactory.get((SepaVersion)version);
        parser.parse((InputStream)new ByteArrayInputStream(bos.toByteArray()), props);
        return props.toArray(new Properties[0]);
    }

    @Override
    final void commit(Object[] objects, IOFormat format, InputStream is, ProgressMonitor monitor) throws Exception {
        this.kontenCache.clear();
        super.commit(objects, format, is, monitor);
    }

    protected Konto findKonto(String iban) throws RemoteException, ApplicationException {
        Konto k = this.kontenCache.get(iban);
        if (k != null) {
            return k;
        }
        k = KontoUtil.findByIBAN(iban);
        if (k == null) {
            KontoAuswahlDialog d = new KontoAuswahlDialog(null, KontoFilter.FOREIGN, 1);
            d.setText(i18n.tr("Konto {0} nicht gefunden\nBitte w\u00e4hlen Sie das zu verwendende Konto aus.", iban == null || iban.length() == 0 ? i18n.tr("<unbekannt>") : iban));
            try {
                k = (Konto)d.open();
            }
            catch (OperationCanceledException oce) {
                throw new ApplicationException(i18n.tr("Auftrag wird \u00fcbersprungen"));
            }
            catch (Exception e) {
                throw new ApplicationException(i18n.tr("Fehler beim Ausw\u00e4hlen des Kontos"), (Throwable)e);
            }
        }
        if (k != null) {
            this.kontenCache.put(iban, k);
            return k;
        }
        throw new ApplicationException(i18n.tr("Kein Konto ausgew\u00e4hlt"));
    }

    protected double parseValue(String s) {
        if (s == null || s.trim().length() == 0) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (Exception e) {
            Logger.error((String)("unable to parse as double: " + s), (Throwable)e);
            return Double.NaN;
        }
    }

    abstract SepaVersion.Type getSupportedPainType();
}

