/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.UmsatzTree;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.Date;

public abstract class AbstractUmsatzTreeExporter
implements Exporter {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (!UmsatzTree.class.equals((Object)objectType)) {
            return null;
        }
        IOFormat myFormat = new IOFormat(){

            @Override
            public String getName() {
                return AbstractUmsatzTreeExporter.this.getName();
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"pdf"};
            }
        };
        return new IOFormat[]{myFormat};
    }

    protected String getSubTitle(UmsatzTree tree) throws RemoteException {
        String et;
        String titel = tree.getTitle();
        Date start = tree.getStart();
        Date end = tree.getEnd();
        DateFormat df = HBCI.DATEFORMAT;
        String tt = titel != null ? titel : i18n.tr("alle Konten");
        String st = start != null ? df.format(start) : null;
        String string = et = end != null ? df.format(end) : null;
        if (st == null && end == null) {
            return i18n.tr("gesamter Zeitraum, {0}", tt);
        }
        if (start == null) {
            return i18n.tr("Zeitraum: bis {0}, {1}", new String[]{et, tt});
        }
        if (end == null) {
            return i18n.tr("Zeitraum: ab {0}, {1}", new String[]{st, tt});
        }
        return i18n.tr("Zeitraum: {0} - {1}, {2}", new String[]{st, et, tt});
    }

    @Override
    public boolean suppportsExtension(String ext) {
        return false;
    }
}

