/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.GenericObject;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Importer;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.GV.parsers.SEPAParserFactory;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.sepa.SepaVersion;

public class CamtUmsatzImporter
implements Importer {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void doImport(Object context, IOFormat format, InputStream is, ProgressMonitor monitor, BackgroundTask t) throws RemoteException, ApplicationException {
        if (is == null) {
            throw new ApplicationException(i18n.tr("Keine zu importierende Datei ausgew\u00e4hlt"));
        }
        if (format == null || !(format instanceof MyIOFormat)) {
            throw new ApplicationException(i18n.tr("Kein Datei-Format ausgew\u00e4hlt"));
        }
        MyIOFormat myFormat = (MyIOFormat)format;
        try {
            try {
                Konto konto = null;
                if (context != null && context instanceof Konto) {
                    konto = (Konto)context;
                }
                if (konto == null) {
                    KontoAuswahlDialog d = new KontoAuswahlDialog(1);
                    d.setText(i18n.tr("Bitte w\u00e4hlen Sie das zu verwendende Konto aus."));
                    konto = (Konto)d.open();
                }
                if (monitor != null) {
                    monitor.setStatusText(i18n.tr("Lese Datei ein"));
                }
                Stats stats = new Stats();
                if (myFormat.isZip()) {
                    Logger.info((String)"reading zip file");
                    ZipInputStream zis = new ZipInputStream(is);
                    ZipEntry ze = null;
                    double fc = 22.0;
                    int no = 1;
                    while ((ze = zis.getNextEntry()) != null) {
                        String name;
                        if (ze.isDirectory() || (name = ze.getName()) == null || !name.toLowerCase().endsWith(".xml")) continue;
                        Logger.info((String)("  reading " + name));
                        int chunk = (int)(100.0 / fc);
                        Stats s = this.doImport(chunk, no, zis, konto, monitor, t);
                        stats.created += s.created;
                        stats.error += s.error;
                        ++no;
                    }
                } else {
                    Logger.info((String)"reading xml file");
                    stats = this.doImport(100, 1, is, konto, monitor, t);
                }
                monitor.setStatusText(i18n.tr("{0} Ums\u00e4tze erfolgreich importiert, {1} fehlerhafte \u00fcbersprungen", new String[]{Integer.toString(stats.created), Integer.toString(stats.error)}));
            }
            catch (OperationCanceledException oce) {
                Logger.warn((String)"operation cancelled");
                throw new ApplicationException(i18n.tr("Import abgebrochen"));
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception e) {
                Logger.error((String)"error while reading file", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Import der Datei"));
            }
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{is});
    }

    private Stats doImport(int chunk, int no, InputStream is, Konto konto, ProgressMonitor monitor, BackgroundTask t) throws Exception {
        Stats stats = new Stats();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        IOUtil.copy((InputStream)is, (OutputStream)bos);
        SepaVersion version = SepaVersion.autodetect((InputStream)new ByteArrayInputStream(bos.toByteArray()));
        if (version == null) {
            throw new ApplicationException(i18n.tr("SEPA-Version der XML-Datei nicht ermittelbar"));
        }
        SepaVersion.Type type = version.getType();
        if (type == null || type != SepaVersion.Type.CAMT_052) {
            throw new ApplicationException(i18n.tr("Keine g\u00fcltige CAMT-Datei"));
        }
        if (monitor != null) {
            monitor.log(i18n.tr("Datei {0}, SEPA-Version: {1}", new String[]{Integer.toString(no), version.getURN()}));
        }
        ArrayList tage = new ArrayList();
        ISEPAParser parser = SEPAParserFactory.get((SepaVersion)version);
        parser.parse((InputStream)new ByteArrayInputStream(bos.toByteArray()), tage);
        ArrayList lines = new ArrayList();
        for (GVRKUms.BTag tag : tage) {
            lines.addAll(tag.lines);
        }
        double factor = (double)chunk / (double)lines.size();
        int i = 0;
        while (i < lines.size()) {
            if (monitor != null) {
                int add = (int)((double)(i + 1) * factor);
                monitor.log(i18n.tr("Umsatz {0}", Integer.toString(i + 1)));
                int offset = 0;
                if (chunk < 100) {
                    offset = chunk * no;
                }
                monitor.setPercentComplete(offset + add);
            }
            try {
                if (t != null && t.isInterrupted()) {
                    throw new OperationCanceledException();
                }
                Umsatz umsatz = Converter.HBCIUmsatz2HibiscusUmsatz((GVRKUms.UmsLine)lines.get(i));
                umsatz.setKonto(konto);
                umsatz.store();
                ++stats.created;
                try {
                    Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)umsatz));
                }
                catch (Exception ex) {
                    Logger.error((String)"error while sending import message", (Throwable)ex);
                }
            }
            catch (ApplicationException ae) {
                if (monitor != null) {
                    monitor.log("  " + ae.getMessage());
                }
                ++stats.error;
            }
            catch (Exception e) {
                Logger.error((String)"unable to import line", (Throwable)e);
                if (monitor != null) {
                    monitor.log("  " + i18n.tr("Fehler beim Import des Datensatzes: {0}", e.getMessage()));
                }
                ++stats.error;
            }
            ++i;
        }
        return stats;
    }

    @Override
    public String getName() {
        return i18n.tr("SEPA CAMT-Format");
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (!Umsatz.class.equals((Object)objectType)) {
            return null;
        }
        MyIOFormat fXml = new MyIOFormat(){

            @Override
            public String getName() {
                return String.valueOf(CamtUmsatzImporter.this.getName()) + " (XML)";
            }

            @Override
            public boolean isZip() {
                return false;
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"*.xml"};
            }
        };
        MyIOFormat fZip = new MyIOFormat(){

            @Override
            public String getName() {
                return String.valueOf(CamtUmsatzImporter.this.getName()) + " (ZIP)";
            }

            @Override
            public boolean isZip() {
                return true;
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"*.zip"};
            }
        };
        return new IOFormat[]{fXml, fZip};
    }

    private static interface MyIOFormat
    extends IOFormat {
        public boolean isZip();
    }

    private class Stats {
        private int created = 0;
        private int error = 0;

        private Stats() {
        }
    }
}

