/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.gui.GUI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.logging.Logger;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class ClipboardSepaUeberweisungImporter {
    private static final Pattern PT_SPLIT = Pattern.compile(":[\n\r]+", 8);
    private static final Pattern PT_KONTO = Pattern.compile("(.*iban.*)|(.*Konto.*)|(.*Kto.*)", 2);
    private static final Pattern PT_BLZ = Pattern.compile("(.*bic.*)", 2);
    private static final Pattern PT_ZWECK = Pattern.compile("(.*zweck.*)", 2);
    private static final Pattern PT_NAME = Pattern.compile("(.*Inhaber.*)|(.*Name.*)|(.*Empf\u00e4nger.*)|(.*Empfaenger.*)", 2);

    public AuslandsUeberweisung getUeberweisung() {
        String text;
        block8: {
            Clipboard cb = new Clipboard(GUI.getDisplay());
            TextTransfer transfer = TextTransfer.getInstance();
            text = (String)cb.getContents((Transfer)transfer);
            if (text != null && text.length() != 0) break block8;
            return null;
        }
        try {
            text = text.trim();
            text = PT_SPLIT.matcher(text).replaceAll(":");
            StringTokenizer st = new StringTokenizer(text, System.getProperty("line.separator", "\n"));
            HashMap<String, String> values = new HashMap<String, String>();
            while (st.hasMoreTokens()) {
                int sep;
                String line = st.nextToken();
                if (line == null || line.length() <= 0 || (sep = (line = line.replaceAll("\\s", " ")).indexOf(":")) == -1) continue;
                values.put(line.substring(0, sep).trim(), line.substring(sep + 1).trim());
            }
            AuslandsUeberweisung u = (AuslandsUeberweisung)Settings.getDBService().createObject(AuslandsUeberweisung.class, null);
            for (String s : values.keySet()) {
                String value = (String)values.get(s);
                if (value == null || s == null) continue;
                if (PT_BLZ.matcher(s).matches()) {
                    u.setGegenkontoBLZ(value.replaceAll(" ", ""));
                    continue;
                }
                if (PT_NAME.matcher(s).matches()) {
                    u.setGegenkontoName(value);
                    continue;
                }
                if (PT_KONTO.matcher(s).matches()) {
                    u.setGegenkontoNummer(value.replaceAll(" ", ""));
                    continue;
                }
                if (!PT_ZWECK.matcher(s).matches()) continue;
                u.setZweck(value);
            }
            return u;
        }
        catch (Throwable t) {
            Logger.debug((String)("unable to parse clipboard data: " + t.getMessage()));
            return null;
        }
    }
}

