/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfPCell;
import de.willuhn.datasource.GenericIterator;
import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Reporter;
import de.willuhn.jameica.hbci.rmi.EinnahmeAusgabeZeitraum;
import de.willuhn.jameica.hbci.server.EinnahmeAusgabe;
import de.willuhn.jameica.hbci.server.EinnahmeAusgabeTreeNode;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Date;

public class EinnahmeAusgabeExporter
implements Exporter {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        if (objects == null || !(objects instanceof EinnahmeAusgabeZeitraum[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Daten aus"));
        }
        if (objects.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Daten aus"));
        }
        EinnahmeAusgabeZeitraum[] data = (EinnahmeAusgabeZeitraum[])objects;
        Reporter reporter = null;
        try {
            try {
                reporter = new Reporter(os, monitor, i18n.tr("Einnahmen/Ausgaben"), this.getZeitraum(data), data.length);
                reporter.addHeaderColumn(i18n.tr("Konto"), 1, 100, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Anfangssaldo"), 1, 60, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Einnahmen"), 1, 60, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Ausgaben"), 1, 60, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Endsaldo"), 1, 60, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Plus/Minus"), 1, 60, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Differenz"), 1, 60, Reporter.COLOR_BG);
                reporter.createHeader();
                EinnahmeAusgabeZeitraum[] einnahmeAusgabeZeitraumArray = data;
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    EinnahmeAusgabeZeitraum e = einnahmeAusgabeZeitraumArray[n2];
                    if (e instanceof EinnahmeAusgabeTreeNode) {
                        this.report((EinnahmeAusgabeTreeNode)e, reporter);
                    } else {
                        this.report((EinnahmeAusgabe)e, reporter, 0.0f);
                    }
                    ++n2;
                }
                if (monitor != null) {
                    monitor.setStatus(4);
                }
            }
            catch (DocumentException e) {
                if (monitor != null) {
                    monitor.setStatus(3);
                }
                Logger.error((String)"error while creating report", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Erzeugen der Auswertung"), (Throwable)e);
            }
        }
        finally {
            if (reporter != null) {
                try {
                    reporter.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close report", (Throwable)e);
                }
            }
        }
    }

    private String getZeitraum(EinnahmeAusgabeZeitraum[] objects) {
        Date start = null;
        Date end = null;
        EinnahmeAusgabeZeitraum[] einnahmeAusgabeZeitraumArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            EinnahmeAusgabeZeitraum n3 = einnahmeAusgabeZeitraumArray[n2];
            Date s = n3.getStartdatum();
            if (start == null || s != null && s.before(start)) {
                start = s;
            }
            Date e = n3.getEnddatum();
            if (end == null || e != null && e.after(end)) {
                end = e;
            }
            ++n2;
        }
        if (start != null && end != null) {
            return i18n.tr("Zeitraum {0} - {1}", new String[]{HBCI.DATEFORMAT.format(start), HBCI.DATEFORMAT.format(end)});
        }
        return "";
    }

    private void report(EinnahmeAusgabeTreeNode treeNode, Reporter reporter) throws RemoteException {
        PdfPCell cell = reporter.getDetailCell(treeNode.getText(), 0, null, null, 1);
        cell.setColspan(7);
        reporter.addColumn(cell);
        reporter.setNextRecord();
        GenericIterator eas = treeNode.getChildren();
        while (eas.hasNext()) {
            GenericObject ea = eas.next();
            this.report((EinnahmeAusgabe)ea, reporter, 5.0f);
        }
    }

    private void report(EinnahmeAusgabe ea, Reporter reporter, float indent) {
        PdfPCell cell = reporter.getDetailCell(ea.getText(), 0);
        cell.setPaddingLeft(indent);
        reporter.addColumn(cell);
        reporter.addColumn(reporter.getDetailCell(ea.getAnfangssaldo(), Reporter.COLOR_FG));
        reporter.addColumn(reporter.getDetailCell(ea.getEinnahmen(), Reporter.COLOR_FG));
        reporter.addColumn(reporter.getDetailCell(ea.getAusgaben(), Reporter.COLOR_FG));
        reporter.addColumn(reporter.getDetailCell(ea.getEndsaldo(), Reporter.COLOR_FG));
        double sum = ea.getPlusminus();
        reporter.addColumn(reporter.getDetailCell(sum, sum >= 0.01 ? Reporter.COLOR_GREEN : (sum <= -0.01 ? Reporter.COLOR_RED : Reporter.COLOR_FG)));
        double diff = ea.getDifferenz();
        reporter.addColumn(reporter.getDetailCell(diff, Math.abs(diff) >= 0.01 ? Reporter.COLOR_RED : Reporter.COLOR_FG));
        reporter.setNextRecord();
    }

    @Override
    public boolean suppportsExtension(String ext) {
        return false;
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (!EinnahmeAusgabeZeitraum.class.equals((Object)objectType)) {
            return null;
        }
        IOFormat myFormat = new IOFormat(){

            @Override
            public String getName() {
                return i18n.tr("PDF-Format: Einnahmen/Ausgaben");
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"pdf"};
            }
        };
        return new IOFormat[]{myFormat};
    }

    @Override
    public String getName() {
        return i18n.tr("PDF-Format: Einnahmen/Ausgaben");
    }
}

