/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IO;
import de.willuhn.jameica.hbci.io.Importer;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ClassFinder;
import java.util.ArrayList;
import java.util.List;

public class IORegistry {
    private static List<Exporter> exporters = null;
    private static List<Importer> importers = null;

    static {
        Logger.info((String)"looking for installed export filters");
        exporters = IORegistry.load(Exporter.class);
        Logger.info((String)"looking for installed import filters");
        importers = IORegistry.load(Importer.class);
    }

    private static synchronized <T extends IO> List<T> load(Class<? extends IO> type) {
        BeanService service = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
        ArrayList<IO> l = new ArrayList<IO>();
        try {
            ClassFinder finder = Application.getPluginLoader().getPlugin(HBCI.class).getManifest().getClassLoader().getClassFinder();
            Class[] list = finder.findImplementors(type);
            if (list == null || list.length == 0) {
                throw new ClassNotFoundException();
            }
            Class[] classArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Class c = classArray[n2];
                try {
                    IO io = (IO)service.get(c);
                    Logger.info((String)("  " + io.getName() + " - " + c.getName()));
                    l.add(io);
                }
                catch (Exception e) {
                    Logger.error((String)("error while loading import/export filter " + c.getName()), (Throwable)e);
                }
                ++n2;
            }
        }
        catch (ClassNotFoundException e) {
            Logger.warn((String)("no filters found for type: " + type.getName()));
        }
        return l;
    }

    public static Exporter[] getExporters() {
        return exporters.toArray(new Exporter[0]);
    }

    public static Importer[] getImporters() {
        return importers.toArray(new Importer[0]);
    }
}

