/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class MT940UmsatzExporter
implements Exporter {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    protected static final String NL = "\r\n";
    protected static final DateFormat DF_YYMMDD = new SimpleDateFormat("yyMMdd");
    protected static final DateFormat DF_MMDD = new SimpleDateFormat("MMdd");
    protected static final DecimalFormat DECF = new DecimalFormat("###,###,##0.00", new DecimalFormatSymbols(Locale.GERMANY));
    public static final String CHARSET = "iso-8859-1";

    static {
        DECF.setGroupingUsed(false);
    }

    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        MyOutputStreamWriter out = null;
        try {
            try {
                out = new MyOutputStreamWriter(os);
                double factor = 1.0;
                if (monitor != null) {
                    factor = (double)(100 - monitor.getPercentComplete()) / (double)objects.length;
                    monitor.setStatusText(i18n.tr("Exportiere Daten"));
                }
                LinkedList<Umsatz> list = new LinkedList<Umsatz>();
                int i = 0;
                while (i < objects.length) {
                    if (objects[i] != null && objects[i] instanceof Umsatz) {
                        list.add((Umsatz)objects[i]);
                    }
                    ++i;
                }
                this.sort(list);
                Boolean b = (Boolean)Exporter.SESSION.get((Object)"saldo.show");
                boolean showSaldo = b == null || b != false;
                int i2 = 0;
                while (i2 < list.size()) {
                    String[] lines;
                    boolean hasTags;
                    Umsatz u;
                    String name;
                    if (monitor != null) {
                        monitor.setPercentComplete((int)((double)i2 * factor));
                    }
                    if ((name = BeanUtil.toString((Object)(u = (Umsatz)list.get(i2)))) != null && monitor != null) {
                        monitor.log(i18n.tr("Speichere Datensatz {0}", name.toString()));
                    }
                    Konto k = u.getKonto();
                    String curr = k.getWaehrung();
                    if (i2 > 0) {
                        ((Writer)out).write(NL);
                    }
                    ((Writer)out).write(":20:STARTUMS\r\n");
                    ((Writer)out).write(":25:" + k.getBLZ() + "/" + k.getKontonummer() + NL);
                    ((Writer)out).write(":28C:1\r\n");
                    if (showSaldo) {
                        double anfangsSaldo = u.getSaldo() - u.getBetrag();
                        ((Writer)out).write(":60F:");
                        ((Writer)out).write(anfangsSaldo >= 0.0 ? "C" : "D");
                        ((Writer)out).write(String.valueOf(DF_YYMMDD.format(u.getDatum())) + curr + DECF.format(anfangsSaldo).replace("-", "") + NL);
                    }
                    ((Writer)out).write(":61:" + DF_YYMMDD.format(u.getValuta()) + DF_MMDD.format(u.getDatum()));
                    double betrag = u.getBetrag();
                    ((Writer)out).write(betrag >= 0.0 ? "CR" : "DR");
                    ((Writer)out).write(DECF.format(betrag).replace("-", ""));
                    String ref = StringUtils.trimToNull((String)u.getCustomerRef());
                    ((Writer)out).write("NTRF" + (ref != null ? ref : "NONREF") + NL);
                    String gvcode = u.getGvCode();
                    if (StringUtils.trimToNull((String)gvcode) == null) {
                        gvcode = betrag >= 0.0 ? "051" : "020";
                    }
                    ((Writer)out).write(":86:" + gvcode + "?00" + StringUtils.trimToEmpty((String)u.getArt()) + "?10" + StringUtils.trimToEmpty((String)u.getPrimanota()));
                    int m = 0;
                    String parsed = VerwendungszweckUtil.getTag(u, VerwendungszweckUtil.Tag.SVWZ);
                    String raw = VerwendungszweckUtil.toString(u);
                    boolean bl = hasTags = !Objects.equals(parsed, raw) && raw.contains(VerwendungszweckUtil.Tag.SVWZ.name());
                    if (hasTags) {
                        lines = VerwendungszweckUtil.rewrap(27, VerwendungszweckUtil.toArray(u));
                        m = 0;
                        while (m < lines.length) {
                            if (m <= 9) {
                                ((Writer)out).write("?2" + Integer.toString(m) + lines[m]);
                                ++m;
                                continue;
                            }
                            break;
                        }
                    } else {
                        lines = VerwendungszweckUtil.rewrap(27, parsed);
                        int l = 0;
                        while (l < lines.length) {
                            if (l <= 9) {
                                m = this.addRef(out, m, VerwendungszweckUtil.Tag.SVWZ, lines[l]);
                                ++l;
                                continue;
                            }
                            break;
                        }
                    }
                    m = this.addRef(out, m, VerwendungszweckUtil.Tag.EREF, u.getEndToEndId());
                    m = this.addRef(out, m, VerwendungszweckUtil.Tag.KREF, u.getCustomerRef());
                    m = this.addRef(out, m, VerwendungszweckUtil.Tag.MREF, u.getMandateId());
                    m = this.addRef(out, m, VerwendungszweckUtil.Tag.CRED, u.getCreditorId());
                    String blz = StringUtils.trimToNull((String)u.getGegenkontoBLZ());
                    String kto = StringUtils.trimToNull((String)u.getGegenkontoNummer());
                    String nam = StringUtils.trimToNull((String)u.getGegenkontoName());
                    String add = StringUtils.trimToNull((String)u.getAddKey());
                    if (blz != null) {
                        ((Writer)out).write("?30" + blz);
                    }
                    if (kto != null) {
                        ((Writer)out).write("?31" + kto);
                    }
                    if (nam != null) {
                        ((Writer)out).write("?32" + nam);
                    }
                    if (add != null) {
                        ((Writer)out).write("?34" + add);
                    }
                    ((Writer)out).write(NL);
                    if (showSaldo) {
                        ((Writer)out).write(":62F:");
                        double schlussSaldo = u.getSaldo();
                        ((Writer)out).write(schlussSaldo >= 0.0 ? "C" : "D");
                        ((Writer)out).write(String.valueOf(DF_YYMMDD.format(u.getDatum())) + curr + DECF.format(schlussSaldo).replace("-", "") + NL);
                    }
                    ((Writer)out).write("-");
                    ++i2;
                }
                ((Writer)out).write(NL);
            }
            catch (IOException e) {
                Logger.error((String)"unable to write MT940 file", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Export der Daten. " + e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{out});
    }

    protected int addRef(OutputStreamWriter out, int m, VerwendungszweckUtil.Tag tag, String text) throws IOException {
        if (m > 9) {
            return m;
        }
        if ((text = StringUtils.trimToNull((String)text)) == null) {
            return m;
        }
        out.write("?2" + Integer.toString(m) + tag.name() + "+" + text);
        return ++m;
    }

    protected void sort(List<Umsatz> list) {
        Collections.sort(list, new Comparator<Umsatz>(){

            @Override
            public int compare(Umsatz o1, Umsatz o2) {
                Date d2;
                Date d1;
                block7: {
                    block6: {
                        block5: {
                            try {
                                d1 = (Date)o1.getAttribute("datum_pseudo");
                                d2 = (Date)o2.getAttribute("datum_pseudo");
                                if (d1 != d2) break block5;
                                return 0;
                            }
                            catch (RemoteException re) {
                                Logger.error((String)"unable to sort data", (Throwable)re);
                                return 0;
                            }
                        }
                        if (d1 != null) break block6;
                        return -1;
                    }
                    if (d2 != null) break block7;
                    return 1;
                }
                return d1.compareTo(d2);
            }
        });
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (!Umsatz.class.equals((Object)objectType)) {
            return null;
        }
        return new IOFormat[]{new IOFormat(){

            @Override
            public String getName() {
                return MT940UmsatzExporter.this.getName();
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"sta"};
            }
        }};
    }

    @Override
    public String getName() {
        return i18n.tr("Swift MT940-Format (pro Buchung eine logische Datei)");
    }

    @Override
    public boolean suppportsExtension(String ext) {
        return ext != null && "saldo.show".equals(ext);
    }

    protected class MyOutputStreamWriter
    extends OutputStreamWriter {
        private String[] search;
        private String[] replace;
        private boolean doReplace;

        public MyOutputStreamWriter(OutputStream out) throws UnsupportedEncodingException {
            super(out, MT940UmsatzExporter.CHARSET);
            this.search = new String[]{"\u00dc", "\u00d6", "\u00c4", "\u00fc", "\u00f6", "\u00e4", "\u00df"};
            this.replace = new String[]{"UE", "OE", "AE", "ue", "oe", "ae", "ss"};
            this.doReplace = true;
            this.doReplace = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings().getBoolean("export.mt940.replaceumlauts", true);
        }

        @Override
        public void write(String str) throws IOException {
            if (this.doReplace) {
                str = StringUtils.replaceEach((String)str, (String[])this.search, (String[])this.replace);
            }
            super.write(str);
        }
    }
}

