/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.MT940UmsatzExporter;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class MT940UmsatzExporterMerged
extends MT940UmsatzExporter {
    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        MT940UmsatzExporter.MyOutputStreamWriter out = null;
        try {
            try {
                out = new MT940UmsatzExporter.MyOutputStreamWriter(os);
                double factor = 1.0;
                if (monitor != null) {
                    factor = (double)(100 - monitor.getPercentComplete()) / (double)objects.length;
                    monitor.setStatusText(i18n.tr("Exportiere Daten"));
                }
                Konto k = null;
                LinkedList<Umsatz> list = new LinkedList<Umsatz>();
                int i = 0;
                while (i < objects.length) {
                    if (objects[i] != null && objects[i] instanceof Umsatz) {
                        Umsatz u = (Umsatz)objects[i];
                        Konto konto = u.getKonto();
                        if (k == null) {
                            k = konto;
                        } else if (!k.getID().equals(konto.getID())) {
                            throw new ApplicationException(i18n.tr("Die zu exportierenden Ums\u00e4tze m\u00fcssen vom selben Konto stammen"));
                        }
                        list.add(u);
                    }
                    ++i;
                }
                this.sort(list);
                String curr = k.getWaehrung();
                Boolean b = (Boolean)Exporter.SESSION.get((Object)"saldo.show");
                boolean showSaldo = b == null || b != false;
                ((Writer)out).write(":20:STARTUMS\r\n");
                ((Writer)out).write(":25:" + k.getBLZ() + "/" + k.getKontonummer() + "\r\n");
                ((Writer)out).write(":28C:1\r\n");
                int i2 = 0;
                while (i2 < list.size()) {
                    String[] lines;
                    boolean hasTags;
                    Umsatz u;
                    String name;
                    if (monitor != null) {
                        monitor.setPercentComplete((int)((double)i2 * factor));
                    }
                    if ((name = BeanUtil.toString((Object)(u = (Umsatz)list.get(i2)))) != null && monitor != null) {
                        monitor.log(i18n.tr("Speichere Datensatz {0}", name.toString()));
                    }
                    if (showSaldo && i2 == 0) {
                        double saldo = u.getSaldo() - u.getBetrag();
                        ((Writer)out).write(":60F:");
                        ((Writer)out).write(saldo >= 0.0 ? "C" : "D");
                        ((Writer)out).write(String.valueOf(DF_YYMMDD.format(u.getDatum())) + curr + DECF.format(saldo).replace("-", "") + "\r\n");
                    }
                    ((Writer)out).write(":61:" + DF_YYMMDD.format(u.getValuta()) + DF_MMDD.format(u.getDatum()));
                    double betrag = u.getBetrag();
                    ((Writer)out).write(betrag >= 0.0 ? "CR" : "DR");
                    ((Writer)out).write(DECF.format(betrag).replace("-", ""));
                    String ref = StringUtils.trimToNull((String)u.getCustomerRef());
                    ((Writer)out).write("NTRF" + (ref != null ? ref : "NONREF") + "\r\n");
                    String gvcode = u.getGvCode();
                    if (StringUtils.trimToNull((String)gvcode) == null) {
                        gvcode = betrag >= 0.0 ? "051" : "020";
                    }
                    ((Writer)out).write(":86:" + gvcode + "?00" + StringUtils.trimToEmpty((String)u.getArt()) + "?10" + StringUtils.trimToEmpty((String)u.getPrimanota()));
                    int m = 0;
                    String parsed = VerwendungszweckUtil.getTag(u, VerwendungszweckUtil.Tag.SVWZ);
                    String raw = VerwendungszweckUtil.toString(u);
                    boolean bl = hasTags = !Objects.equals(parsed, raw) && raw.contains(VerwendungszweckUtil.Tag.SVWZ.name());
                    if (hasTags) {
                        lines = VerwendungszweckUtil.rewrap(27, VerwendungszweckUtil.toArray(u));
                        m = 0;
                        while (m < lines.length) {
                            if (m <= 9) {
                                ((Writer)out).write("?2" + Integer.toString(m) + lines[m]);
                                ++m;
                                continue;
                            }
                            break;
                        }
                    } else {
                        lines = VerwendungszweckUtil.rewrap(27, parsed);
                        int l = 0;
                        while (l < lines.length) {
                            if (l <= 9) {
                                m = this.addRef(out, m, VerwendungszweckUtil.Tag.SVWZ, lines[l]);
                                ++l;
                                continue;
                            }
                            break;
                        }
                    }
                    m = this.addRef(out, m, VerwendungszweckUtil.Tag.EREF, u.getEndToEndId());
                    m = this.addRef(out, m, VerwendungszweckUtil.Tag.KREF, u.getCustomerRef());
                    m = this.addRef(out, m, VerwendungszweckUtil.Tag.MREF, u.getMandateId());
                    m = this.addRef(out, m, VerwendungszweckUtil.Tag.CRED, u.getCreditorId());
                    String blz = StringUtils.trimToNull((String)u.getGegenkontoBLZ());
                    String kto = StringUtils.trimToNull((String)u.getGegenkontoNummer());
                    String nam = StringUtils.trimToNull((String)u.getGegenkontoName());
                    String add = StringUtils.trimToNull((String)u.getAddKey());
                    if (blz != null) {
                        ((Writer)out).write("?30" + blz);
                    }
                    if (kto != null) {
                        ((Writer)out).write("?31" + kto);
                    }
                    if (nam != null) {
                        ((Writer)out).write("?32" + nam);
                    }
                    if (add != null) {
                        ((Writer)out).write("?34" + add);
                    }
                    ((Writer)out).write("\r\n");
                    if (showSaldo && i2 >= list.size() - 1) {
                        ((Writer)out).write(":62F:");
                        double schlussSaldo = u.getSaldo();
                        ((Writer)out).write(schlussSaldo >= 0.0 ? "C" : "D");
                        ((Writer)out).write(String.valueOf(DF_YYMMDD.format(u.getDatum())) + curr + DECF.format(schlussSaldo).replace("-", "") + "\r\n");
                    }
                    ++i2;
                }
                ((Writer)out).write("-");
                ((Writer)out).write("\r\n");
            }
            catch (IOException e) {
                Logger.error((String)"unable to write MT940 file", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Export der Daten. " + e.getMessage()));
            }
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{out});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{out});
    }

    @Override
    public String getName() {
        return i18n.tr("Swift MT940-Format (alle Buchungen in einer logischen Datei)");
    }
}

