/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.GenericObject;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Importer;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.Converter;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.manager.HBCIKey;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.swift.Swift;

public class MT940UmsatzImporter
implements Importer {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void doImport(Object context, IOFormat format, InputStream is, ProgressMonitor monitor, BackgroundTask t) throws RemoteException, ApplicationException {
        List lines;
        Konto konto;
        block22: {
            if (is == null) {
                throw new ApplicationException(i18n.tr("Keine zu importierende Datei ausgew\u00e4hlt"));
            }
            if (format == null) {
                throw new ApplicationException(i18n.tr("Kein Datei-Format ausgew\u00e4hlt"));
            }
            konto = null;
            if (context != null && context instanceof Konto) {
                konto = (Konto)context;
            }
            if (konto == null) {
                KontoAuswahlDialog d = new KontoAuswahlDialog(1);
                d.setText(i18n.tr("Bitte w\u00e4hlen Sie das zu verwendende Konto aus."));
                konto = (Konto)d.open();
            }
            MyGVRKUms umsaetze = new MyGVRKUms();
            if (monitor != null) {
                monitor.setStatusText(i18n.tr("Lese Datei ein"));
            }
            InputStreamReader encodedIs = new InputStreamReader(is, "iso-8859-1");
            StringBuffer sb = new StringBuffer();
            int read = 0;
            char[] buf = new char[8192];
            while ((read = encodedIs.read(buf)) != -1) {
                if (read <= 0) continue;
                sb.append(buf, 0, read);
            }
            umsaetze.appendMT940Data(Swift.decodeUmlauts((String)sb.toString()));
            if (monitor != null) {
                monitor.setStatusText(i18n.tr("Speichere Ums\u00e4tze"));
            }
            if ((lines = umsaetze.getFlatData()).size() != 0) break block22;
            konto.addToProtokoll(i18n.tr("Keine Ums\u00e4tze importiert"), 2);
            IOUtil.close((Closeable[])new Closeable[]{is});
            return;
        }
        try {
            try {
                double factor = 100.0 / (double)lines.size();
                int created = 0;
                int error = 0;
                int i = 0;
                while (i < lines.size()) {
                    if (monitor != null) {
                        monitor.log(i18n.tr("Umsatz {0}", "" + (i + 1)));
                        monitor.setPercentComplete((int)((double)(i + 1) * factor));
                    }
                    try {
                        if (t != null && t.isInterrupted()) {
                            throw new OperationCanceledException();
                        }
                        Umsatz umsatz = Converter.HBCIUmsatz2HibiscusUmsatz((GVRKUms.UmsLine)lines.get(i));
                        umsatz.setKonto(konto);
                        umsatz.store();
                        ++created;
                        try {
                            Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)umsatz));
                        }
                        catch (Exception ex) {
                            Logger.error((String)"error while sending import message", (Throwable)ex);
                        }
                    }
                    catch (ApplicationException ae) {
                        monitor.log("  " + ae.getMessage());
                        ++error;
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to import line", (Throwable)e);
                        monitor.log("  " + i18n.tr("Fehler beim Import des Datensatzes: {0}", e.getMessage()));
                        ++error;
                    }
                    ++i;
                }
                monitor.setStatusText(i18n.tr("{0} Ums\u00e4tze erfolgreich importiert, {1} fehlerhafte \u00fcbersprungen", new String[]{"" + created, "" + error}));
                monitor.addPercentComplete(1);
            }
            catch (OperationCanceledException oce) {
                Logger.warn((String)"operation cancelled");
                throw new ApplicationException(i18n.tr("Import abgebrochen"));
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (Exception e) {
                Logger.error((String)"error while reading file", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Import der Datei"));
            }
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{is});
    }

    @Override
    public String getName() {
        return i18n.tr("Swift MT940-Format");
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (!Umsatz.class.equals((Object)objectType)) {
            return null;
        }
        IOFormat f = new IOFormat(){

            @Override
            public String getName() {
                return MT940UmsatzImporter.this.getName();
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"*.sta"};
            }
        };
        return new IOFormat[]{f};
    }

    private class MyGVRKUms
    extends GVRKUms {
        private MyGVRKUms() {
        }

        public HBCIPassport getPassport() {
            return new HBCIPassport(){

                public void syncSysId() {
                }

                public void syncSigId() {
                }

                public void setUserId(String userid) {
                }

                public void setPort(Integer port) {
                }

                public void setHost(String host) {
                }

                public void setFilterType(String filter) {
                }

                public void setCustomerId(String customerid) {
                }

                public void setCountry(String country) {
                }

                public void setClientData(String id, Object o) {
                }

                public void setBLZ(String blz) {
                }

                public void saveChanges() {
                }

                public boolean onlyBPDGVs() {
                    return false;
                }

                public boolean needUserKeys() {
                    return false;
                }

                public boolean needInstKeys() {
                    return false;
                }

                public boolean isSupported() {
                    return false;
                }

                public boolean hasMySigKey() {
                    return false;
                }

                public boolean hasMyEncKey() {
                    return false;
                }

                public boolean hasInstSigKey() {
                    return false;
                }

                public boolean hasInstEncKey() {
                    return false;
                }

                public String getUserId() {
                    return null;
                }

                public String getUPDVersion() {
                    return null;
                }

                public Properties getUPD() {
                    return null;
                }

                public String[] getSuppVersions() {
                    return null;
                }

                public String[][] getSuppSecMethods() {
                    return null;
                }

                public String[] getSuppLangs() {
                    return null;
                }

                public String[][] getSuppCompMethods() {
                    return null;
                }

                public Integer getPort() {
                    return null;
                }

                public HBCIKey getMyPublicSigKey() {
                    return null;
                }

                public HBCIKey getMyPublicEncKey() {
                    return null;
                }

                public HBCIKey getMyPublicDigKey() {
                    return null;
                }

                public HBCIKey getMyPrivateSigKey() {
                    return null;
                }

                public HBCIKey getMyPrivateEncKey() {
                    return null;
                }

                public HBCIKey getMyPrivateDigKey() {
                    return null;
                }

                public int getMaxMsgSizeKB() {
                    return 0;
                }

                public int getMaxGVperMsg() {
                    return 0;
                }

                public HBCIKey getInstSigKey() {
                    return null;
                }

                public String getInstName() {
                    return null;
                }

                public HBCIKey getInstEncKey() {
                    return null;
                }

                public String getHost() {
                    return null;
                }

                public String getHBCIVersion() {
                    return null;
                }

                public String getFilterType() {
                    return null;
                }

                public String getDefaultLang() {
                    return null;
                }

                public String getCustomerId(int idx) {
                    return null;
                }

                public String getCustomerId() {
                    return null;
                }

                public String getCountry() {
                    return null;
                }

                public Object getClientData(String id) {
                    return null;
                }

                public String getBPDVersion() {
                    return null;
                }

                public Properties getBPD() {
                    return null;
                }

                public String getBLZ() {
                    return null;
                }

                public org.kapott.hbci.structures.Konto[] getAccounts() {
                    return null;
                }

                public org.kapott.hbci.structures.Konto getAccount(String number) {
                    return null;
                }

                public void fillAccountInfo(org.kapott.hbci.structures.Konto account) {
                }

                public void close() {
                }

                public void clearUPD() {
                }

                public void clearInstSigKey() {
                }

                public void clearInstEncKey() {
                }

                public void clearBPD() {
                }

                public void changePassphrase() {
                }
            };
        }
    }
}

