/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.rmi.DBIterator;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Importer;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLParserFactory;

public class MoneyplexUmsatzImporter
implements Importer {
    private static final de.willuhn.jameica.system.Settings settings = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings();
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("dd.MM.yy");
    private Map<String, UmsatzTyp> cache = new HashMap<String, UmsatzTyp>();

    @Override
    public void doImport(Object context, IOFormat format, InputStream is, ProgressMonitor monitor, BackgroundTask t) throws RemoteException, ApplicationException {
        this.cache.clear();
        if (is == null) {
            throw new ApplicationException(i18n.tr("Keine zu importierende Datei ausgew\u00e4hlt"));
        }
        if (format == null) {
            throw new ApplicationException(i18n.tr("Kein Datei-Format ausgew\u00e4hlt"));
        }
        try {
            try {
                Konto konto = null;
                if (context != null && context instanceof Konto) {
                    konto = (Konto)context;
                }
                if (konto == null) {
                    KontoAuswahlDialog d = new KontoAuswahlDialog(1);
                    d.setText(i18n.tr("Bitte w\u00e4hlen Sie das zu verwendende Konto aus."));
                    konto = (Konto)d.open();
                }
                if (monitor != null) {
                    monitor.setStatusText(i18n.tr("Lese Datei ein"));
                }
                String encoding = settings.getString("moneyplex.encoding", "ISO-8859-1");
                Logger.info((String)("moneyplex encoding: " + encoding));
                IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
                parser.setReader((IXMLReader)new StdXMLReader((Reader)new InputStreamReader(is, encoding)));
                IXMLElement root = (IXMLElement)parser.parse();
                Vector lines = root.getChildrenNamed("BUCHUNG");
                if (lines == null || lines.size() == 0) {
                    throw new ApplicationException(i18n.tr("Datei enth\u00e4lt keine Buchungen"));
                }
                double factor = 100.0 / (double)lines.size();
                int created = 0;
                int error = 0;
                int i = 0;
                while (i < lines.size()) {
                    if (monitor != null) {
                        monitor.setPercentComplete((int)((double)(i + 1) * factor));
                    }
                    if (t != null && t.isInterrupted()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        int count = this.process((IXMLElement)lines.get(i), konto);
                        int c = 0;
                        while (c < count) {
                            monitor.log(i18n.tr("Umsatz {0}", "" + (created + c + 1)));
                            ++c;
                        }
                        created += count;
                    }
                    catch (ApplicationException ae) {
                        monitor.log("  " + ae.getMessage());
                        ++error;
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to import line", (Throwable)e);
                        monitor.log("  " + i18n.tr("Fehler beim Import des Datensatzes: {0}", e.getMessage()));
                        ++error;
                    }
                    ++i;
                }
                monitor.setStatusText(i18n.tr("{0} Ums\u00e4tze erfolgreich importiert, {1} fehlerhafte \u00fcbersprungen", new String[]{"" + created, "" + error}));
                monitor.addPercentComplete(1);
            }
            catch (ApplicationException ae) {
                throw ae;
            }
            catch (OperationCanceledException oce) {
                Logger.warn((String)"operation cancelled");
                throw new ApplicationException(i18n.tr("Import abgebrochen"));
            }
            catch (Exception e) {
                Logger.error((String)"error while reading file", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Import der Datei"));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Logger.error((String)"error while closing inputstream", (Throwable)e);
                }
            }
        }
    }

    private int process(IXMLElement line, Konto konto) throws Exception {
        IXMLElement split;
        Umsatz umsatz = (Umsatz)Settings.getDBService().createObject(Umsatz.class, null);
        Date valuta = this.parseDatum(line.getFirstChildNamed("VALUTA"));
        Date datum = this.parseDatum(line.getFirstChildNamed("DATUM"));
        Date date = valuta != null ? valuta : (valuta = datum != null ? datum : new Date());
        datum = datum != null ? datum : (valuta != null ? valuta : new Date());
        umsatz.setKonto(konto);
        umsatz.setDatum(datum);
        umsatz.setValuta(valuta);
        IXMLElement empfaenger = line.getFirstChildNamed("EMPFAENGER");
        if (empfaenger != null) {
            umsatz.setGegenkontoName(this.getContent(empfaenger.getFirstChildNamed("NAME")));
        }
        if ((split = line.getFirstChildNamed("SPLITT")) != null) {
            Vector parts = split.getChildrenNamed("PART");
            if (parts == null || parts.size() == 0) {
                throw new ApplicationException("Split-Auftrag ohne enthaltene Buchungen");
            }
            for (IXMLElement p : parts) {
                Umsatz copy = (Umsatz)umsatz.duplicate();
                String usage = this.getContent(p.getFirstChildNamed("ZWECK"));
                if (usage != null) {
                    VerwendungszweckUtil.apply(copy, usage.split("@"));
                }
                copy.setUmsatzTyp(this.createTyp(p.getFirstChildNamed("KATEGORIE")));
                copy.setBetrag(this.parseBetrag(p.getFirstChildNamed("BETRAG")));
                copy.store();
                try {
                    Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)copy));
                }
                catch (Exception ex) {
                    Logger.error((String)"error while sending import message", (Throwable)ex);
                }
            }
            return parts.size();
        }
        String usage = this.getContent(line.getFirstChildNamed("ZWECK"));
        if (usage != null) {
            VerwendungszweckUtil.apply(umsatz, usage.split("@"));
        }
        umsatz.setUmsatzTyp(this.createTyp(line.getFirstChildNamed("KATEGORIE")));
        umsatz.setBetrag(this.parseBetrag(line.getFirstChildNamed("BETRAG")));
        umsatz.store();
        try {
            Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)umsatz));
        }
        catch (Exception ex) {
            Logger.error((String)"error while sending import message", (Throwable)ex);
        }
        return 1;
    }

    private String getContent(IXMLElement e) {
        if (e == null) {
            return null;
        }
        String s = e.getContent();
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    private double parseBetrag(IXMLElement e) {
        String s = this.getContent(e);
        if (s == null) {
            return Double.NaN;
        }
        try {
            return HBCI.DECIMALFORMAT.parse(s).doubleValue();
        }
        catch (Exception ex) {
            Logger.warn((String)("unable to parse value " + s + ": " + ex.getMessage()));
            return Double.NaN;
        }
    }

    private Date parseDatum(IXMLElement e) {
        String s = this.getContent(e);
        if (s == null) {
            return null;
        }
        try {
            return DATEFORMAT.parse(s);
        }
        catch (Exception ex) {
            Logger.warn((String)("unable to parse date " + s + ": " + ex.getMessage()));
            return null;
        }
    }

    private UmsatzTyp createTyp(IXMLElement e) {
        String s = this.getContent(e);
        if (s == null) {
            return null;
        }
        UmsatzTyp typ = this.cache.get(s);
        if (typ != null) {
            return typ;
        }
        try {
            String[] names = s.split(":");
            if (names.length > 1) {
                String name;
                UmsatzTyp parent = null;
                boolean found = true;
                String[] stringArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    name = stringArray[n2];
                    typ = this.findTyp(name, parent);
                    if (typ == null) {
                        found = false;
                        break;
                    }
                    parent = typ;
                    ++n2;
                }
                if (!found) {
                    parent = null;
                    Logger.info((String)("creating categories for path: " + s));
                    stringArray = names;
                    n = names.length;
                    n2 = 0;
                    while (n2 < n) {
                        name = stringArray[n2];
                        typ = this.findTyp(name, parent);
                        if (typ == null) {
                            typ = (UmsatzTyp)Settings.getDBService().createObject(UmsatzTyp.class, null);
                            typ.setParent(parent);
                            typ.setName(name);
                            typ.store();
                        }
                        parent = typ;
                        ++n2;
                    }
                }
                this.cache.put(s, typ);
                return typ;
            }
            typ = this.findTyp(s, null);
            if (typ == null) {
                Logger.info((String)("creating category: " + s));
                typ = (UmsatzTyp)Settings.getDBService().createObject(UmsatzTyp.class, null);
                typ.setName(s);
                typ.store();
            }
            this.cache.put(s, typ);
            return typ;
        }
        catch (Exception ex) {
            Logger.error((String)("unable to load/create category " + s + ": "), (Throwable)ex);
            return null;
        }
    }

    private UmsatzTyp findTyp(String name, UmsatzTyp parent) throws Exception {
        DBIterator i = Settings.getDBService().createList(UmsatzTyp.class);
        i.addFilter("name = ?", new Object[]{name});
        if (parent != null) {
            i.addFilter("parent_id = " + parent.getID());
        }
        if (i.hasNext()) {
            return (UmsatzTyp)i.next();
        }
        return null;
    }

    @Override
    public String getName() {
        return i18n.tr("Moneyplex-Format");
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (!Umsatz.class.equals((Object)objectType)) {
            return null;
        }
        IOFormat f = new IOFormat(){

            @Override
            public String getName() {
                return MoneyplexUmsatzImporter.this.getName();
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"*.xml"};
            }
        };
        return new IOFormat[]{f};
    }
}

