/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfWriter;
import de.willuhn.io.IOUtil;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Reporter {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private List<PdfPCell> headers = new ArrayList<PdfPCell>();
    private List<Integer> widths = new ArrayList<Integer>();
    private OutputStream out = null;
    private Document rpt = null;
    private PdfPTable table = null;
    private int maxRecords = 0;
    private int currRecord = 0;
    private ProgressMonitor monitor = null;
    public static final BaseColor COLOR_FG = BaseColor.BLACK;
    public static final BaseColor COLOR_BG = BaseColor.LIGHT_GRAY;
    public static final BaseColor COLOR_RED = new BaseColor(150, 0, 0);
    public static final BaseColor COLOR_GREEN = new BaseColor(0, 100, 0);
    public static final BaseColor COLOR_WHITE = BaseColor.WHITE;
    public static final BaseColor COLOR_GRAY = BaseColor.GRAY;

    public Reporter(OutputStream out, ProgressMonitor monitor, String title, String subtitle, int maxRecords) throws DocumentException {
        this.out = out;
        this.monitor = monitor;
        this.maxRecords = maxRecords;
        this.rpt = new Document();
        PdfWriter writer = PdfWriter.getInstance((Document)this.rpt, (OutputStream)out);
        this.rpt.setMargins(80.0f, 30.0f, 20.0f, 45.0f);
        if (this.monitor != null) {
            this.monitor.setStatusText(i18n.tr("Erzeuge Liste"));
            this.monitor.addPercentComplete(1);
        }
        Manifest mf = Application.getPluginLoader().getManifest(HBCI.class);
        this.rpt.addAuthor(i18n.tr("{0} - Version {1}", new String[]{mf.getName(), mf.getVersion().toString()}));
        this.rpt.addTitle(subtitle);
        HeaderFooter hf = new HeaderFooter();
        writer.setPageEvent((PdfPageEvent)hf);
        hf.setFooter(i18n.tr("{0} | {1} | erstellt am {2}              Seite:  ", new String[]{title, subtitle, HBCI.LONGDATEFORMAT.format(new Date())}));
        this.rpt.open();
        try {
            URL url = mf.getClassLoader().getResource("icons/hibiscus-icon-64x64.png");
            Image image = Image.getInstance((URL)url);
            image.scaleAbsolute(32.0f, 32.0f);
            this.rpt.add((Element)image);
        }
        catch (Exception e) {
            Logger.error((String)"unable to add hibiscus icon, will be ignored", (Throwable)e);
        }
        Paragraph pTitle = new Paragraph(title, FontFactory.getFont((String)"Helvetica-Bold", (float)13.0f));
        pTitle.setAlignment(1);
        this.rpt.add((Element)pTitle);
        Paragraph psubTitle = new Paragraph(subtitle, FontFactory.getFont((String)"Helvetica-Bold", (float)10.0f));
        psubTitle.setAlignment(1);
        this.rpt.add((Element)psubTitle);
    }

    public void add(Paragraph p) throws DocumentException {
        this.rpt.add((Element)p);
    }

    public void addHeaderColumn(String text, int align, int width, BaseColor color) {
        this.headers.add(this.getDetailCell(text, align, color));
        this.widths.add(width);
    }

    public void addColumn(PdfPCell cell) {
        this.table.addCell(cell);
    }

    public void setNextRecord() {
        ++this.currRecord;
        if (this.monitor != null) {
            this.monitor.setPercentComplete(this.currRecord / this.maxRecords * 100);
        }
    }

    public void createHeader() throws DocumentException {
        this.table = new PdfPTable(this.headers.size());
        int[] w = new int[this.headers.size()];
        int i = 0;
        while (i < this.headers.size()) {
            w[i] = this.widths.get(i);
            ++i;
        }
        this.table.setWidths(w);
        this.table.setWidthPercentage(100.0f);
        this.table.setSpacingBefore(10.0f);
        this.table.setSpacingAfter(0.0f);
        i = 0;
        while (i < this.headers.size()) {
            this.table.addCell(this.headers.get(i));
            ++i;
        }
        this.table.setHeaderRows(1);
    }

    public void close() throws IOException, DocumentException {
        try {
            if (this.monitor != null) {
                this.monitor.setPercentComplete(100);
                this.monitor.setStatusText(i18n.tr("PDF-Export beendet"));
            }
            this.rpt.add((Element)this.table);
            this.rpt.close();
        }
        catch (Throwable throwable) {
            IOUtil.close((Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
        IOUtil.close((Closeable[])new Closeable[]{this.out});
    }

    public PdfPCell getDetailCell(String text, int align, BaseColor backgroundcolor) {
        return this.getDetailCell(text, align, backgroundcolor, null, 0);
    }

    public PdfPCell getDetailCell(String text, int align) {
        return this.getDetailCell(text, align, null);
    }

    public PdfPCell getDetailCell(String text, int align, BaseColor backgroundColor, BaseColor textColor, int fontStyle) {
        PdfPCell cell = new PdfPCell(new Phrase(this.notNull(text), FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)fontStyle, (BaseColor)(textColor != null ? textColor : COLOR_FG))));
        cell.setHorizontalAlignment(align);
        cell.setBackgroundColor(backgroundColor != null ? backgroundColor : COLOR_WHITE);
        return cell;
    }

    public PdfPCell getDetailCell(Double value) {
        return this.getDetailCell((double)value);
    }

    public PdfPCell getDetailCell(double value) {
        return this.getDetailCell(value, value >= 0.01 ? COLOR_FG : COLOR_RED);
    }

    public PdfPCell getDetailCell(double value, BaseColor color) {
        return this.getDetailCell(value, color, 0);
    }

    public PdfPCell getDetailCell(double value, BaseColor color, int fontStyle) {
        Font f = FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)fontStyle, (BaseColor)(color != null ? color : (value >= 0.01 ? COLOR_FG : COLOR_RED)));
        PdfPCell cell = new PdfPCell(new Phrase(HBCI.DECIMALFORMAT.format(value), f));
        cell.setHorizontalAlignment(2);
        return cell;
    }

    public String notNull(String text) {
        return text == null ? "" : text;
    }

    private class HeaderFooter
    extends PdfPageEventHelper {
        private String footer = null;
        private int pagenumber = 0;

        private HeaderFooter() {
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
        }

        public void onChapter(PdfWriter writer, Document document, float paragraphPosition, Paragraph title) {
        }

        public void onStartPage(PdfWriter writer, Document document) {
            ++this.pagenumber;
        }

        public void setFooter(String footer) {
            this.footer = footer;
        }

        public void onEndPage(PdfWriter writer, Document document) {
            Rectangle rect = document.getPageSize();
            switch (writer.getPageNumber() % 2) {
                case 0: {
                    break;
                }
            }
            float left = rect.getLeft() + document.leftMargin();
            float right = rect.getRight() - document.rightMargin();
            float bottom = rect.getBottom() + document.bottomMargin();
            PdfContentByte pc = writer.getDirectContent();
            pc.setColorStroke(COLOR_FG);
            pc.setLineWidth(0.5f);
            pc.moveTo(left, bottom - 5.0f);
            pc.lineTo(right, bottom - 5.0f);
            pc.stroke();
            pc.moveTo(left, bottom - 25.0f);
            pc.lineTo(right, bottom - 25.0f);
            pc.stroke();
            ColumnText.showTextAligned((PdfContentByte)pc, (int)1, (Phrase)new Phrase(String.valueOf(this.footer) + " " + this.pagenumber, FontFactory.getFont((String)"Helvetica", (float)8.0f, (int)0)), (float)((left + right) / 2.0f), (float)(bottom - 18.0f), (float)0.0f);
        }
    }
}

