/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.io.AbstractSepaExporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ProgressMonitor;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.sepa.SepaVersion;

public class SepaLastschriftExporter
extends AbstractSepaExporter {
    private static final DateFormat ISO_DATE = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    void setup(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws Exception {
        HashSet<String> conflict = new HashSet<String>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            conflict.add(this.createKey((SepaLastschrift)o));
            if (conflict.size() > 1) break;
            ++n2;
        }
        if (conflict.size() > 1) {
            String txt = i18n.tr("Die Lastschriften enthalten unterschiedliche Lastschrift-Arten, Sequenz-Typen oder Zieltermine.\nSie k\u00f6nnen daher nicht in eine einzelne SEPA XML-Datei exportiert werden.");
            Application.getCallback().notifyUser(txt);
            throw new OperationCanceledException("conflicting sequencetype, targetdate or type");
        }
        super.setup(objects, format, os, monitor);
    }

    @Override
    protected void exportObject(Object o, int idx, AbstractSepaExporter.JobContext ctx) throws Exception {
        Properties props = ctx.props;
        SepaLastschrift u = (SepaLastschrift)o;
        Konto k = u.getKonto();
        if (idx == 0) {
            SepaLastType type = u.getType();
            if (type == null) {
                type = SepaLastType.DEFAULT;
            }
            props.setProperty("sequencetype", u.getSequenceType().name());
            props.setProperty("targetdate", u.getTargetDate() != null ? ISO_DATE.format(u.getTargetDate()) : "1999-01-01");
            props.setProperty("type", type.name());
        }
        props.setProperty(SepaUtil.insertIndex((String)"dst.bic", (Integer)idx), StringUtils.trimToEmpty((String)u.getGegenkontoBLZ()));
        props.setProperty(SepaUtil.insertIndex((String)"dst.iban", (Integer)idx), StringUtils.trimToEmpty((String)u.getGegenkontoNummer()));
        props.setProperty(SepaUtil.insertIndex((String)"dst.name", (Integer)idx), StringUtils.trimToEmpty((String)u.getGegenkontoName()));
        props.setProperty(SepaUtil.insertIndex((String)"btg.value", (Integer)idx), HBCIUtils.value2String((double)u.getBetrag()));
        props.setProperty(SepaUtil.insertIndex((String)"btg.curr", (Integer)idx), k.getWaehrung() != null ? k.getWaehrung() : HBCIProperties.CURRENCY_DEFAULT_DE);
        props.setProperty(SepaUtil.insertIndex((String)"usage", (Integer)idx), StringUtils.trimToEmpty((String)u.getZweck()));
        props.setProperty(SepaUtil.insertIndex((String)"endtoendid", (Integer)idx), StringUtils.trimToEmpty((String)u.getEndtoEndId()));
        props.setProperty(SepaUtil.insertIndex((String)"creditorid", (Integer)idx), StringUtils.trimToEmpty((String)u.getCreditorId()));
        props.setProperty(SepaUtil.insertIndex((String)"mandateid", (Integer)idx), StringUtils.trimToEmpty((String)u.getMandateId()));
        props.setProperty(SepaUtil.insertIndex((String)"manddateofsig", (Integer)idx), ISO_DATE.format(u.getSignatureDate()));
        props.setProperty(SepaUtil.insertIndex((String)"purposecode", (Integer)idx), StringUtils.trimToEmpty((String)u.getPurposeCode()));
        props.setProperty("pmtinfid", StringUtils.trimToEmpty((String)u.getPmtInfId()));
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_008;
    }

    @Override
    protected String getJobName() {
        return SepaLastType.CORE.getJobName();
    }

    @Override
    Class[] getSupportedObjectTypes() {
        return new Class[]{SepaLastschrift.class};
    }

    private String createKey(SepaLastschrift l) throws RemoteException {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(l.getSequenceType().name()) + "-");
        SepaLastType type = l.getType();
        if (type == null) {
            type = SepaLastType.DEFAULT;
        }
        sb.append(String.valueOf(type.name()) + "-");
        Date target = l.getTargetDate();
        if (target != null) {
            sb.append(String.valueOf(HBCI.DATEFORMAT.format(target)) + "-");
        }
        return sb.toString();
    }
}

