/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.io.AbstractSepaImporter;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.SepaLastSequenceType;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.SepaVersion;

public class SepaLastschriftImporter
extends AbstractSepaImporter {
    private static final DateFormat ISO_DATE = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    void importObject(Object o, int idx, Map ctx) throws Exception {
        HBCIDBService service = Settings.getDBService();
        Properties prop = (Properties)o;
        SepaLastschrift u = (SepaLastschrift)service.createObject(SepaLastschrift.class, null);
        u.setKonto(this.findKonto(prop.getProperty(ISEPAParser.Names.SRC_IBAN.getValue())));
        u.setGegenkontoName(prop.getProperty(ISEPAParser.Names.DST_NAME.getValue()));
        u.setGegenkontoNummer(prop.getProperty(ISEPAParser.Names.DST_IBAN.getValue()));
        u.setGegenkontoBLZ(prop.getProperty(ISEPAParser.Names.DST_BIC.getValue()));
        u.setZweck(prop.getProperty(ISEPAParser.Names.USAGE.getValue()));
        u.setBetrag(this.parseValue(prop.getProperty(ISEPAParser.Names.VALUE.getValue())));
        String date = StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.TARGETDATE.getValue()));
        if (date != null && !"1999-01-01".equals(date)) {
            u.setTargetDate(ISO_DATE.parse(date));
        }
        u.setEndtoEndId(StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.ENDTOENDID.getValue())));
        u.setPmtInfId(StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.PMTINFID.getValue())));
        u.setPurposeCode(StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.PURPOSECODE.getValue())));
        u.setCreditorId(prop.getProperty(ISEPAParser.Names.CREDITORID.getValue()));
        u.setMandateId(prop.getProperty(ISEPAParser.Names.MANDATEID.getValue()));
        String mandDate = StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.MANDDATEOFSIG.getValue()));
        if (mandDate != null && !"1999-01-01".equals(mandDate)) {
            u.setSignatureDate(ISO_DATE.parse(mandDate));
        }
        u.setSequenceType(SepaLastSequenceType.valueOf(prop.getProperty(ISEPAParser.Names.SEQUENCETYPE.getValue(), SepaLastSequenceType.FRST.name())));
        u.setType(SepaLastType.valueOf(prop.getProperty(ISEPAParser.Names.LAST_TYPE.getValue(), SepaLastType.CORE.name())));
        u.store();
        Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)u));
    }

    @Override
    Class[] getSupportedObjectTypes() {
        return new Class[]{SepaLastschrift.class};
    }

    @Override
    SepaVersion.Type getSupportedPainType() {
        return SepaVersion.Type.PAIN_008;
    }
}

