/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.dialogs.SepaTransferMergeDialog;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.messaging.ObjectDeletedMessage;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaLastschrift;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastBuchung;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class SepaLastschriftMerger {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private int skipCount = 0;

    public List<SepaSammelLastschrift> merge(List<SepaLastschrift> lastschriften) throws ApplicationException {
        if (lastschriften == null || lastschriften.size() == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie einen oder mehrere Auftr\u00e4ge aus"));
        }
        ArrayList<SepaSammelLastschrift> result = new ArrayList<SepaSammelLastschrift>();
        SepaSammelLastschrift tx = null;
        try {
            SepaTransferMergeDialog dialog;
            Object o;
            HBCIDBService service = Settings.getDBService();
            HashMap<String, SepaSammelLastschrift> map = new HashMap<String, SepaSammelLastschrift>();
            boolean inDb = false;
            for (SepaLastschrift l : lastschriften) {
                inDb |= !l.isNewObject();
                String key = this.createKey(l);
                SepaSammelLastschrift s = (SepaSammelLastschrift)map.get(key);
                if (s != null) continue;
                s = (SepaSammelLastschrift)service.createObject(SepaSammelLastschrift.class, null);
                s.setKonto(l.getKonto());
                s.setBezeichnung(i18n.tr("{0} {1} vom {2}", new String[]{l.getSequenceType().getDescription(), l.getType().getDescription(), HBCI.LONGDATEFORMAT.format(new Date())}));
                s.setSequenceType(l.getSequenceType());
                s.setType(l.getType());
                s.setTargetDate(l.getTargetDate());
                map.put(key, s);
            }
            boolean delete = false;
            int count = map.size();
            if ((count > 1 || inDb) && (o = (dialog = new SepaTransferMergeDialog(1, count, inDb)).open()) != null) {
                delete = (Boolean)o;
            }
            for (SepaSammelLastschrift s : map.values()) {
                if (tx == null) {
                    tx = s;
                    tx.transactionBegin();
                }
                s.store();
                Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)s));
                result.add(s);
            }
            for (SepaLastschrift l : lastschriften) {
                String key = this.createKey(l);
                SepaSammelLastschrift s = (SepaSammelLastschrift)map.get(key);
                if (s == null) {
                    Logger.error((String)("unable to find sepa transfer for key " + key));
                    continue;
                }
                SepaSammelLastBuchung b = (SepaSammelLastBuchung)s.createBuchung();
                b.setBetrag(l.getBetrag());
                b.setCreditorId(l.getCreditorId());
                b.setEndtoEndId(l.getEndtoEndId());
                b.setGegenkontoBLZ(l.getGegenkontoBLZ());
                b.setGegenkontoName(l.getGegenkontoName());
                b.setGegenkontoNummer(l.getGegenkontoNummer());
                b.setMandateId(l.getMandateId());
                b.setSignatureDate(l.getSignatureDate());
                b.setZweck(l.getZweck());
                b.store();
                Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)b));
                Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)s));
                if (!delete || l.isNewObject()) continue;
                if (MetaKey.REMINDER_UUID.get(l) != null) {
                    ++this.skipCount;
                    continue;
                }
                String id = l.getID();
                l.delete();
                Application.getMessagingFactory().sendMessage((Message)new ObjectDeletedMessage((GenericObject)l, id));
            }
            tx.transactionCommit();
            return result;
        }
        catch (Exception e) {
            if (tx != null) {
                try {
                    tx.transactionRollback();
                }
                catch (Exception e2) {
                    Logger.error((String)"unable to rollback transaction", (Throwable)e);
                }
            }
            if (e instanceof OperationCanceledException) {
                throw (OperationCanceledException)((Object)e);
            }
            if (e instanceof ApplicationException) {
                throw (ApplicationException)((Object)e);
            }
            Logger.error((String)"error while merging jobs", (Throwable)e);
            throw new ApplicationException(i18n.tr("Zusammenfassen der Lastschriften fehlgeschlagen: {0}", e.getMessage()));
        }
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    private String createKey(SepaLastschrift l) throws RemoteException {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(l.getKonto().getID()) + "-");
        sb.append(String.valueOf(l.getSequenceType().name()) + "-");
        SepaLastType type = l.getType();
        if (type == null) {
            type = SepaLastType.DEFAULT;
        }
        sb.append(String.valueOf(type.name()) + "-");
        Date target = l.getTargetDate();
        if (target != null) {
            sb.append(String.valueOf(HBCI.DATEFORMAT.format(target)) + "-");
        }
        return sb.toString();
    }
}

