/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.io.AbstractSepaExporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastBuchung;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.util.ProgressMonitor;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.sepa.SepaVersion;

public class SepaSammelLastschriftExporter
extends AbstractSepaExporter {
    private static final DateFormat ISO_DATE = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    void setup(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws Exception {
        HashSet<String> conflict = new HashSet<String>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            conflict.add(this.createKey((SepaSammelLastschrift)o));
            if (conflict.size() > 1) break;
            ++n2;
        }
        if (conflict.size() > 1) {
            String txt = i18n.tr("Die Lastschriften enthalten unterschiedliche Lastschrift-Arten, Sequenz-Typen oder Zieltermine.\nSie k\u00f6nnen daher nicht in eine einzelne SEPA XML-Datei exportiert werden.");
            Application.getCallback().notifyUser(txt);
            throw new OperationCanceledException("conflicting sequencetype, targetdate or type");
        }
        super.setup(objects, format, os, monitor);
    }

    @Override
    protected void exportObject(Object o, int idx, AbstractSepaExporter.JobContext ctx) throws Exception {
        Integer count;
        Properties props = ctx.props;
        SepaSammelLastschrift u = (SepaSammelLastschrift)o;
        Konto k = u.getKonto();
        if (idx == 0) {
            SepaLastType type = u.getType();
            if (type == null) {
                type = SepaLastType.DEFAULT;
            }
            props.setProperty("pmtinfid", StringUtils.trimToEmpty((String)u.getPmtInfId()));
            props.setProperty("sequencetype", u.getSequenceType().name());
            props.setProperty("targetdate", u.getTargetDate() != null ? ISO_DATE.format(u.getTargetDate()) : "1999-01-01");
            props.setProperty("type", type.name());
            String batchbook = MetaKey.SEPA_BATCHBOOK.get(u);
            if (batchbook != null) {
                props.setProperty("batchbook", batchbook);
            }
        }
        if ((count = (Integer)ctx.meta.get("count")) == null) {
            count = 0;
        }
        List buchungen = u.getBuchungen();
        for (SepaSammelLastBuchung b : buchungen) {
            props.setProperty(SepaUtil.insertIndex((String)"dst.bic", (Integer)count), StringUtils.trimToEmpty((String)b.getGegenkontoBLZ()));
            props.setProperty(SepaUtil.insertIndex((String)"dst.iban", (Integer)count), StringUtils.trimToEmpty((String)b.getGegenkontoNummer()));
            props.setProperty(SepaUtil.insertIndex((String)"dst.name", (Integer)count), StringUtils.trimToEmpty((String)b.getGegenkontoName()));
            props.setProperty(SepaUtil.insertIndex((String)"btg.value", (Integer)count), HBCIUtils.value2String((double)b.getBetrag()));
            props.setProperty(SepaUtil.insertIndex((String)"btg.curr", (Integer)count), k.getWaehrung() != null ? k.getWaehrung() : HBCIProperties.CURRENCY_DEFAULT_DE);
            props.setProperty(SepaUtil.insertIndex((String)"usage", (Integer)count), StringUtils.trimToEmpty((String)b.getZweck()));
            props.setProperty(SepaUtil.insertIndex((String)"endtoendid", (Integer)count), StringUtils.trimToEmpty((String)b.getEndtoEndId()));
            props.setProperty(SepaUtil.insertIndex((String)"creditorid", (Integer)count), StringUtils.trimToEmpty((String)b.getCreditorId()));
            props.setProperty(SepaUtil.insertIndex((String)"mandateid", (Integer)count), StringUtils.trimToEmpty((String)b.getMandateId()));
            props.setProperty(SepaUtil.insertIndex((String)"manddateofsig", (Integer)count), ISO_DATE.format(b.getSignatureDate()));
            props.setProperty(SepaUtil.insertIndex((String)"purposecode", (Integer)count), StringUtils.trimToEmpty((String)b.getPurposeCode()));
            count = count + 1;
        }
        ctx.meta.put("count", count);
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_008;
    }

    @Override
    protected String getJobName() {
        return SepaLastType.CORE.getJobName();
    }

    @Override
    Class[] getSupportedObjectTypes() {
        return new Class[]{SepaSammelLastschrift.class};
    }

    private String createKey(SepaSammelLastschrift l) throws RemoteException {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(l.getSequenceType().name()) + "-");
        SepaLastType type = l.getType();
        if (type == null) {
            type = SepaLastType.DEFAULT;
        }
        sb.append(String.valueOf(type.name()) + "-");
        Date target = l.getTargetDate();
        if (target != null) {
            sb.append(String.valueOf(HBCI.DATEFORMAT.format(target)) + "-");
        }
        return sb.toString();
    }
}

