/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.io.AbstractSepaImporter;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.messaging.ObjectChangedMessage;
import de.willuhn.jameica.hbci.rmi.BatchBookType;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.hbci.rmi.SepaLastSequenceType;
import de.willuhn.jameica.hbci.rmi.SepaLastType;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastBuchung;
import de.willuhn.jameica.hbci.rmi.SepaSammelLastschrift;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.SepaVersion;

public class SepaSammelLastschriftImporter
extends AbstractSepaImporter {
    private static final DateFormat ISO_DATE = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    void importObject(Object o, int idx, Map ctx) throws Exception {
        HBCIDBService service = Settings.getDBService();
        Properties prop = (Properties)o;
        SepaSammelLastschrift ueb = (SepaSammelLastschrift)ctx.get("ueb");
        if (ueb == null) {
            ueb = (SepaSammelLastschrift)service.createObject(SepaSammelLastschrift.class, null);
            ueb.setSequenceType(SepaLastSequenceType.valueOf(prop.getProperty(ISEPAParser.Names.SEQUENCETYPE.getValue(), SepaLastSequenceType.FRST.name())));
            ueb.setType(SepaLastType.valueOf(prop.getProperty(ISEPAParser.Names.LAST_TYPE.getValue(), SepaLastType.CORE.name())));
            ueb.setBezeichnung(i18n.tr("{0} {1} vom {2}", new String[]{ueb.getSequenceType().getDescription(), ueb.getType().getDescription(), HBCI.LONGDATEFORMAT.format(new Date())}));
            ueb.setKonto(this.findKonto(prop.getProperty(ISEPAParser.Names.SRC_IBAN.getValue())));
            ueb.setPmtInfId(StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.PMTINFID.getValue())));
            String date = StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.TARGETDATE.getValue()));
            if (date != null && !"1999-01-01".equals(date)) {
                ueb.setTargetDate(ISO_DATE.parse(date));
            }
            ueb.store();
            BatchBookType batch = BatchBookType.byXmlValue(prop.getProperty(ISEPAParser.Names.BATCHBOOK.getValue()));
            MetaKey.SEPA_BATCHBOOK.set(ueb, batch != null ? batch.getValue() : null);
            ctx.put("ueb", ueb);
            Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)ueb));
        }
        SepaSammelLastBuchung u = (SepaSammelLastBuchung)ueb.createBuchung();
        u.setGegenkontoName(prop.getProperty(ISEPAParser.Names.DST_NAME.getValue()));
        u.setGegenkontoNummer(prop.getProperty(ISEPAParser.Names.DST_IBAN.getValue()));
        u.setGegenkontoBLZ(prop.getProperty(ISEPAParser.Names.DST_BIC.getValue()));
        u.setZweck(prop.getProperty(ISEPAParser.Names.USAGE.getValue()));
        u.setBetrag(this.parseValue(prop.getProperty(ISEPAParser.Names.VALUE.getValue())));
        u.setEndtoEndId(StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.ENDTOENDID.getValue())));
        u.setPurposeCode(StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.PURPOSECODE.getValue())));
        u.setCreditorId(prop.getProperty(ISEPAParser.Names.CREDITORID.getValue()));
        u.setMandateId(prop.getProperty(ISEPAParser.Names.MANDATEID.getValue()));
        String mandDate = StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.MANDDATEOFSIG.getValue()));
        if (mandDate != null && !"1999-01-01".equals(mandDate)) {
            u.setSignatureDate(ISO_DATE.parse(mandDate));
        }
        u.store();
        Application.getMessagingFactory().sendMessage((Message)new ObjectChangedMessage((GenericObject)ueb));
    }

    @Override
    Class[] getSupportedObjectTypes() {
        return new Class[]{SepaSammelLastschrift.class};
    }

    @Override
    SepaVersion.Type getSupportedPainType() {
        return SepaVersion.Type.PAIN_008;
    }
}

