/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.MetaKey;
import de.willuhn.jameica.hbci.io.AbstractSepaExporter;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisung;
import de.willuhn.jameica.hbci.rmi.SepaSammelUeberweisungBuchung;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.sepa.SepaVersion;

public class SepaSammelUeberweisungExporter
extends AbstractSepaExporter {
    @Override
    protected void exportObject(Object o, int idx, AbstractSepaExporter.JobContext ctx) throws Exception {
        SimpleDateFormat df;
        String date;
        Integer count;
        Properties props = ctx.props;
        SepaSammelUeberweisung u = (SepaSammelUeberweisung)o;
        Konto k = u.getKonto();
        if (idx == 0) {
            String batchbook = MetaKey.SEPA_BATCHBOOK.get(u);
            if (batchbook != null) {
                props.setProperty("batchbook", batchbook);
            }
            props.setProperty("pmtinfid", StringUtils.trimToEmpty((String)u.getPmtInfId()));
        }
        if ((count = (Integer)ctx.meta.get("count")) == null) {
            count = 0;
        }
        List buchungen = u.getBuchungen();
        for (SepaSammelUeberweisungBuchung b : buchungen) {
            props.setProperty(SepaUtil.insertIndex((String)"dst.bic", (Integer)count), StringUtils.trimToEmpty((String)b.getGegenkontoBLZ()));
            props.setProperty(SepaUtil.insertIndex((String)"dst.iban", (Integer)count), StringUtils.trimToEmpty((String)b.getGegenkontoNummer()));
            props.setProperty(SepaUtil.insertIndex((String)"dst.name", (Integer)count), StringUtils.trimToEmpty((String)b.getGegenkontoName()));
            props.setProperty(SepaUtil.insertIndex((String)"btg.value", (Integer)count), HBCIUtils.value2String((double)b.getBetrag()));
            props.setProperty(SepaUtil.insertIndex((String)"btg.curr", (Integer)count), k.getWaehrung() != null ? k.getWaehrung() : HBCIProperties.CURRENCY_DEFAULT_DE);
            props.setProperty(SepaUtil.insertIndex((String)"usage", (Integer)count), StringUtils.trimToEmpty((String)b.getZweck()));
            props.setProperty(SepaUtil.insertIndex((String)"endtoendid", (Integer)count), StringUtils.trimToEmpty((String)b.getEndtoEndId()));
            props.setProperty(SepaUtil.insertIndex((String)"purposecode", (Integer)count), StringUtils.trimToEmpty((String)b.getPurposeCode()));
            count = count + 1;
        }
        if (u.isTerminUeberweisung() && (date = StringUtils.trimToNull((String)(df = new SimpleDateFormat("yyyy-MM-dd")).format(u.getTermin()))) != null) {
            props.setProperty("date", date);
        }
        ctx.meta.put("count", count);
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_001;
    }

    @Override
    protected String getJobName() {
        return "UebSEPA";
    }

    @Override
    Class[] getSupportedObjectTypes() {
        return new Class[]{SepaSammelUeberweisung.class};
    }
}

