/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.hbci.HBCIProperties;
import de.willuhn.jameica.hbci.io.AbstractSepaExporter;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.Konto;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.SepaUtil;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.sepa.SepaVersion;

public class SepaUeberweisungExporter
extends AbstractSepaExporter {
    @Override
    protected void exportObject(Object o, int idx, AbstractSepaExporter.JobContext ctx) throws Exception {
        SimpleDateFormat df;
        String date;
        Properties props = ctx.props;
        AuslandsUeberweisung u = (AuslandsUeberweisung)o;
        Konto k = u.getKonto();
        props.setProperty(SepaUtil.insertIndex((String)"dst.bic", (Integer)idx), StringUtils.trimToEmpty((String)u.getGegenkontoBLZ()));
        props.setProperty(SepaUtil.insertIndex((String)"dst.iban", (Integer)idx), StringUtils.trimToEmpty((String)u.getGegenkontoNummer()));
        props.setProperty(SepaUtil.insertIndex((String)"dst.name", (Integer)idx), StringUtils.trimToEmpty((String)u.getGegenkontoName()));
        props.setProperty(SepaUtil.insertIndex((String)"btg.value", (Integer)idx), HBCIUtils.value2String((double)u.getBetrag()));
        props.setProperty(SepaUtil.insertIndex((String)"btg.curr", (Integer)idx), k.getWaehrung() != null ? k.getWaehrung() : HBCIProperties.CURRENCY_DEFAULT_DE);
        props.setProperty(SepaUtil.insertIndex((String)"usage", (Integer)idx), StringUtils.trimToEmpty((String)u.getZweck()));
        props.setProperty(SepaUtil.insertIndex((String)"endtoendid", (Integer)idx), StringUtils.trimToEmpty((String)u.getEndtoEndId()));
        props.setProperty(SepaUtil.insertIndex((String)"purposecode", (Integer)idx), StringUtils.trimToEmpty((String)u.getPurposeCode()));
        props.setProperty("pmtinfid", StringUtils.trimToEmpty((String)u.getPmtInfId()));
        if (u.isTerminUeberweisung() && (date = StringUtils.trimToNull((String)(df = new SimpleDateFormat("yyyy-MM-dd")).format(u.getTermin()))) != null) {
            props.setProperty("date", date);
        }
    }

    @Override
    protected SepaVersion.Type getPainType() {
        return SepaVersion.Type.PAIN_001;
    }

    @Override
    protected String getJobName() {
        return "UebSEPA";
    }

    @Override
    Class[] getSupportedObjectTypes() {
        return new Class[]{AuslandsUeberweisung.class};
    }
}

