/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.GenericObject;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.io.AbstractSepaImporter;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.hbci.rmi.HBCIDBService;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.kapott.hbci.GV.parsers.ISEPAParser;
import org.kapott.hbci.sepa.SepaVersion;

public class SepaUeberweisungImporter
extends AbstractSepaImporter {
    private static final DateFormat ISO_DATE = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    void importObject(Object o, int idx, Map ctx) throws Exception {
        HBCIDBService service = Settings.getDBService();
        Properties prop = (Properties)o;
        AuslandsUeberweisung u = (AuslandsUeberweisung)service.createObject(AuslandsUeberweisung.class, null);
        u.setKonto(this.findKonto(prop.getProperty(ISEPAParser.Names.SRC_IBAN.getValue())));
        u.setGegenkontoName(prop.getProperty(ISEPAParser.Names.DST_NAME.getValue()));
        u.setGegenkontoNummer(prop.getProperty(ISEPAParser.Names.DST_IBAN.getValue()));
        u.setGegenkontoBLZ(prop.getProperty(ISEPAParser.Names.DST_BIC.getValue()));
        u.setZweck(prop.getProperty(ISEPAParser.Names.USAGE.getValue()));
        u.setBetrag(this.parseValue(prop.getProperty(ISEPAParser.Names.VALUE.getValue())));
        String date = StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.DATE.getValue()));
        if (date != null && !"1999-01-01".equals(date)) {
            u.setTermin(ISO_DATE.parse(date));
            u.setTerminUeberweisung(true);
        }
        u.setEndtoEndId(StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.ENDTOENDID.getValue())));
        u.setPmtInfId(StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.PMTINFID.getValue())));
        u.setPurposeCode(StringUtils.trimToNull((String)prop.getProperty(ISEPAParser.Names.PURPOSECODE.getValue())));
        u.store();
        Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)u));
    }

    @Override
    Class[] getSupportedObjectTypes() {
        return new Class[]{AuslandsUeberweisung.class};
    }

    @Override
    SepaVersion.Type getSupportedPainType() {
        return SepaVersion.Type.PAIN_001;
    }
}

