/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import com.itextpdf.text.pdf.PdfPCell;
import de.willuhn.jameica.hbci.io.AbstractUmsatzTreeExporter;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Reporter;
import de.willuhn.jameica.hbci.io.UmsatzTree;
import de.willuhn.jameica.hbci.server.UmsatzTreeNode;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.List;

public class UmsatzTreeAccountingExporter
extends AbstractUmsatzTreeExporter {
    private double einnahmen = 0.0;
    private double ausgaben = 0.0;
    private double betrag = 0.0;

    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        if (objects == null || !(objects instanceof UmsatzTree[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Ums\u00e4tze aus"));
        }
        UmsatzTree[] t = (UmsatzTree[])objects;
        if (t.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Ums\u00e4tze aus"));
        }
        this.einnahmen = 0.0;
        this.ausgaben = 0.0;
        this.betrag = 0.0;
        UmsatzTree tree = t[0];
        List list = tree.getUmsatzTree();
        Reporter reporter = null;
        try {
            try {
                reporter = new Reporter(os, monitor, i18n.tr("Umsatzkategorien"), this.getSubTitle(tree), list.size());
                reporter.addHeaderColumn(i18n.tr("Kategorie"), 0, 130, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Einnahmen"), 2, 30, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Ausgaben"), 2, 30, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Betrag"), 2, 30, Reporter.COLOR_BG);
                reporter.createHeader();
                int i = 0;
                while (i < list.size()) {
                    this.renderNode(reporter, (UmsatzTreeNode)list.get(i), 0);
                    reporter.setNextRecord();
                    ++i;
                }
                Boolean b = (Boolean)Exporter.SESSION.get((Object)"sumrow.add");
                if (b != null && b.booleanValue()) {
                    this.renderSum(reporter);
                }
                if (monitor != null) {
                    monitor.setStatus(4);
                }
            }
            catch (Exception e) {
                if (monitor != null) {
                    monitor.setStatus(3);
                }
                Logger.error((String)"error while creating report", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Erzeugen der Auswertung: {0}", e.getMessage()), (Throwable)e);
            }
        }
        finally {
            if (reporter != null) {
                try {
                    reporter.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close report", (Throwable)e);
                }
            }
        }
    }

    private void renderNode(Reporter reporter, UmsatzTreeNode node, int level) throws Exception {
        String name = (String)node.getAttribute("name");
        int j = 0;
        while (j < level) {
            name = "    " + name;
            ++j;
        }
        PdfPCell cell = reporter.getDetailCell(name, 0);
        reporter.addColumn(cell);
        Double de = (Double)node.getAttribute("einnahmen");
        Double da = (Double)node.getAttribute("ausgaben");
        Double db = (Double)node.getAttribute("betrag");
        reporter.addColumn(reporter.getDetailCell(de));
        reporter.addColumn(reporter.getDetailCell(da));
        reporter.addColumn(reporter.getDetailCell(db));
        if (level == 0) {
            this.einnahmen += de.doubleValue();
            this.ausgaben += da.doubleValue();
            this.betrag += db.doubleValue();
        }
        List<UmsatzTreeNode> children = node.getSubGroups();
        int i = 0;
        while (i < children.size()) {
            this.renderNode(reporter, children.get(i), level + 1);
            ++i;
        }
    }

    private void renderSum(Reporter reporter) throws Exception {
        PdfPCell cell = reporter.getDetailCell(i18n.tr("Summe"), 0, null, null, 1);
        reporter.addColumn(cell);
        reporter.addColumn(reporter.getDetailCell(this.einnahmen, null, 1));
        reporter.addColumn(reporter.getDetailCell(this.ausgaben, null, 1));
        reporter.addColumn(reporter.getDetailCell(this.betrag, null, 1));
        this.einnahmen = 0.0;
        this.ausgaben = 0.0;
        this.betrag = 0.0;
    }

    @Override
    public boolean suppportsExtension(String ext) {
        return ext != null && "sumrow.add".equals(ext);
    }

    @Override
    public String getName() {
        return i18n.tr("PDF-Format: Summen aller Kategorien mit Einnahmen und Ausgaben");
    }
}

