/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import com.itextpdf.text.pdf.PdfPCell;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.AbstractUmsatzTreeExporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Reporter;
import de.willuhn.jameica.hbci.io.UmsatzTree;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.server.UmsatzTreeNode;
import de.willuhn.jameica.hbci.server.VerwendungszweckUtil;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.List;

public class UmsatzTreeCompleteExporter
extends AbstractUmsatzTreeExporter {
    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        if (objects == null || !(objects instanceof UmsatzTree[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Ums\u00e4tze aus"));
        }
        UmsatzTree[] t = (UmsatzTree[])objects;
        if (t.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Ums\u00e4tze aus"));
        }
        UmsatzTree tree = t[0];
        List list = tree.getUmsatzTree();
        Reporter reporter = null;
        try {
            try {
                reporter = new Reporter(os, monitor, i18n.tr("Umsatzkategorien"), this.getSubTitle(tree), list.size());
                reporter.addHeaderColumn(i18n.tr("Valuta / Buchungsdatum"), 1, 30, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Empf\u00e4nger/Einzahler"), 1, 100, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Zahlungsgrund"), 1, 120, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Betrag"), 1, 30, Reporter.COLOR_BG);
                reporter.createHeader();
                int i = 0;
                while (i < list.size()) {
                    this.renderNode(reporter, (UmsatzTreeNode)list.get(i));
                    reporter.setNextRecord();
                    ++i;
                }
                if (monitor != null) {
                    monitor.setStatus(4);
                }
            }
            catch (Exception e) {
                if (monitor != null) {
                    monitor.setStatus(3);
                }
                Logger.error((String)"error while creating report", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Erzeugen der Auswertung: {0}", e.getMessage()), (Throwable)e);
            }
        }
        finally {
            if (reporter != null) {
                try {
                    reporter.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close report", (Throwable)e);
                }
            }
        }
    }

    private void renderNode(Reporter reporter, UmsatzTreeNode node) throws Exception {
        int i;
        List<Umsatz> umsaetze = node.getUmsaetze();
        if (umsaetze.size() > 0) {
            PdfPCell cell = reporter.getDetailCell(null, 0);
            cell.setColspan(4);
            reporter.addColumn(cell);
            cell = reporter.getDetailCell((String)node.getAttribute("name"), 0, Reporter.COLOR_BG);
            cell.setColspan(4);
            reporter.addColumn(cell);
            i = 0;
            while (i < umsaetze.size()) {
                Umsatz u = umsaetze.get(i);
                reporter.addColumn(reporter.getDetailCell(String.valueOf(u.getValuta() != null ? HBCI.DATEFORMAT.format(u.getValuta()) : "") + "\n" + (u.getDatum() != null ? HBCI.DATEFORMAT.format(u.getDatum()) : ""), 0));
                reporter.addColumn(reporter.getDetailCell(String.valueOf(reporter.notNull(u.getGegenkontoName())) + "\n" + reporter.notNull(u.getArt()), 0));
                reporter.addColumn(reporter.getDetailCell(VerwendungszweckUtil.toString(u, "\n"), 0));
                reporter.addColumn(reporter.getDetailCell(u.getBetrag()));
                ++i;
            }
            reporter.addColumn(reporter.getDetailCell(null, 0));
            reporter.addColumn(reporter.getDetailCell(i18n.tr("Summe {0}", (String)node.getAttribute("name")), 0));
            reporter.addColumn(reporter.getDetailCell(null, 0));
            reporter.addColumn(reporter.getDetailCell((Double)node.getAttribute("betrag")));
        }
        List<UmsatzTreeNode> children = node.getSubGroups();
        i = 0;
        while (i < children.size()) {
            this.renderNode(reporter, children.get(i));
            ++i;
        }
    }

    @Override
    public String getName() {
        return i18n.tr("PDF-Format: Ums\u00e4tze der Kategorien");
    }
}

