/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import com.itextpdf.text.pdf.PdfPCell;
import de.willuhn.jameica.hbci.io.AbstractUmsatzTreeExporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Reporter;
import de.willuhn.jameica.hbci.io.UmsatzTree;
import de.willuhn.jameica.hbci.server.UmsatzTreeNode;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.ProgressMonitor;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.List;

public class UmsatzTreeSummaryExporter
extends AbstractUmsatzTreeExporter {
    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        if (objects == null || !(objects instanceof UmsatzTree[])) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Ums\u00e4tze aus"));
        }
        UmsatzTree[] t = (UmsatzTree[])objects;
        if (t.length == 0) {
            throw new ApplicationException(i18n.tr("Bitte w\u00e4hlen Sie die zu exportierenden Ums\u00e4tze aus"));
        }
        UmsatzTree tree = t[0];
        List list = tree.getUmsatzTree();
        Reporter reporter = null;
        try {
            try {
                reporter = new Reporter(os, monitor, i18n.tr("Umsatzkategorien"), this.getSubTitle(tree), list.size());
                reporter.addHeaderColumn(i18n.tr("Kategorie"), 1, 130, Reporter.COLOR_BG);
                reporter.addHeaderColumn(i18n.tr("Betrag"), 1, 30, Reporter.COLOR_BG);
                reporter.createHeader();
                int i = 0;
                while (i < list.size()) {
                    UmsatzTreeNode ug = (UmsatzTreeNode)list.get(i);
                    PdfPCell cell = reporter.getDetailCell((String)ug.getAttribute("name"), 0);
                    reporter.addColumn(cell);
                    reporter.addColumn(reporter.getDetailCell((Double)ug.getAttribute("betrag")));
                    reporter.setNextRecord();
                    ++i;
                }
                if (monitor != null) {
                    monitor.setStatus(4);
                }
            }
            catch (Exception e) {
                if (monitor != null) {
                    monitor.setStatus(3);
                }
                Logger.error((String)"error while creating report", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Erzeugen der Auswertung: {0}", e.getMessage()), (Throwable)e);
            }
        }
        finally {
            if (reporter != null) {
                try {
                    reporter.close();
                }
                catch (Exception e) {
                    Logger.error((String)"unable to close report", (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getName() {
        return i18n.tr("PDF-Format: Summen der Hauptkategorien");
    }
}

