/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.io.FileFinder;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.services.VelocityService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityExporter
implements Exporter {
    private static final Settings settings = new Settings(VelocityExporter.class);
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private Map<Class, IOFormat[]> formats = new HashMap<Class, IOFormat[]>();

    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        if (os == null) {
            throw new ApplicationException(i18n.tr("Kein Ausgabe-Ziel f\u00fcr die Datei angegeben"));
        }
        if (format == null) {
            throw new ApplicationException(i18n.tr("Kein Ausgabe-Format angegeben"));
        }
        if (objects == null || objects.length == 0) {
            throw new ApplicationException(i18n.tr("Keine zu exportierenden Ums\u00e4tze angegeben"));
        }
        if (monitor != null) {
            monitor.setStatusText(i18n.tr("Bereite Template vor"));
            monitor.addPercentComplete(1);
        }
        Logger.debug((String)"preparing velocity context");
        VelocityContext context = new VelocityContext();
        String encoding = settings.getString("file.encoding", System.getProperty("file.encoding"));
        Logger.info((String)("used encoding: " + encoding));
        Exporter.SESSION.put((Object)"usage.display.all", (Object)Application.getPluginLoader().getPlugin(HBCI.class).getResources().getSettings().getBoolean("usage.display.all", true));
        context.put("datum", (Object)new Date());
        context.put("charset", (Object)encoding);
        context.put("dateformat", (Object)HBCI.DATEFORMAT);
        context.put("dateutil", (Object)new DateUtil());
        context.put("longdateformat", (Object)HBCI.LONGDATEFORMAT);
        context.put("decimalformat", (Object)HBCI.DECIMALFORMAT);
        context.put("objects", (Object)objects);
        context.put("filter", (Object)new Filter());
        context.put("session", (Object)Exporter.SESSION);
        BufferedWriter writer = null;
        try {
            try {
                if (monitor != null) {
                    monitor.setStatusText(i18n.tr("Exportiere Daten"));
                    monitor.addPercentComplete(4);
                }
                writer = new BufferedWriter(new OutputStreamWriter(os, encoding));
                VelocityService service = (VelocityService)Application.getBootLoader().getBootable(VelocityService.class);
                VelocityEngine engine = service.getEngine(HBCI.class.getName());
                if (engine == null) {
                    throw new Exception("velocity engine not found");
                }
                Template template = engine.getTemplate(((VelocityFormat)format).getTemplate().getName(), "ISO-8859-15");
                template.merge((Context)context, (Writer)writer);
            }
            catch (Exception e) {
                Logger.error((String)"error while writing into export file", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Schreiben in die Export-Datei"));
            }
        }
        finally {
            if (monitor != null) {
                monitor.setStatusText(i18n.tr("Schliesse Export-Datei"));
                monitor.addPercentComplete(1);
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public String getName() {
        return i18n.tr("Velocity-Export");
    }

    @Override
    public IOFormat[] getIOFormats(Class type) {
        if (type == null) {
            return new IOFormat[0];
        }
        IOFormat[] loaded = this.formats.get(type);
        if (loaded != null) {
            return loaded;
        }
        Logger.info((String)("looking velocity templates for object type " + type));
        File dir = new File(String.valueOf(Application.getPluginLoader().getPlugin(HBCI.class).getManifest().getPluginDir()) + File.separator + "lib", "velocity");
        FileFinder finder = new FileFinder(dir);
        String cn = type.getName().replace(".", "\\.");
        cn = cn.replace("$", "\\$");
        finder.matches(String.valueOf(cn) + ".*?\\.vm$");
        File[] found = finder.findRecursive();
        ArrayList<VelocityFormat> l = new ArrayList<VelocityFormat>();
        int i = 0;
        while (i < found.length) {
            String ext;
            int dot;
            File ef = found[i];
            Logger.info((String)("  found template: " + ef.getAbsolutePath()));
            String name = ef.getName();
            name = name.replaceAll(cn, "");
            String variant = null;
            if (name.startsWith("-")) {
                variant = name.substring(1, name.indexOf("."));
            }
            if ((dot = (name = name.substring(name.indexOf(".") + 1)).indexOf(".")) != -1 && (ext = name.substring(0, dot)) != null && ext.length() != 0) {
                l.add(new VelocityFormat(ext, variant, ef));
            }
            ++i;
        }
        loaded = l.toArray(new IOFormat[0]);
        this.formats.put(type, loaded);
        return loaded;
    }

    @Override
    public boolean suppportsExtension(String ext) {
        return false;
    }

    public class DateUtil {
        public DateFormat getFormat(String format) {
            if ((format = StringUtils.trimToNull((String)format)) == null) {
                Logger.warn((String)"no date format given, fallback to default format");
                return HBCI.DATEFORMAT;
            }
            try {
                return new SimpleDateFormat(format);
            }
            catch (Exception e) {
                Logger.error((String)("invalid date format: " + format + " - fallback to default format"), (Throwable)e);
                return HBCI.DATEFORMAT;
            }
        }
    }

    public class Filter {
        public String escape(String s) {
            if (StringUtils.isEmpty((String)s)) {
                return s;
            }
            s = s.replace("\"", "\"\"");
            s = s.replaceAll("[\n\r]", " ");
            return s;
        }
    }

    public class VelocityFormat
    implements IOFormat {
        private String extension = null;
        private String variant = null;
        private File template = null;

        public VelocityFormat(String extension, String variant, File f) {
            this.extension = extension;
            this.variant = variant;
            this.template = f;
        }

        @Override
        public String getName() {
            String name = String.valueOf(this.extension.toUpperCase()) + "-" + i18n.tr("Format");
            if (this.variant != null && this.variant.length() > 0) {
                name = String.valueOf(name) + ": " + i18n.tr(this.variant);
            }
            return name;
        }

        @Override
        public String[] getFileExtensions() {
            return new String[]{this.extension};
        }

        public File getTemplate() {
            return this.template;
        }
    }
}

