/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.BeanUtil;
import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.serialize.XmlWriter;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.io.Exporter;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.rmi.Address;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.system.Application;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;

public class XMLExporter
implements Exporter {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void doExport(Object[] objects, IOFormat format, OutputStream os, ProgressMonitor monitor) throws RemoteException, ApplicationException {
        XmlWriter writer = null;
        try {
            try {
                double factor = 1.0;
                if (monitor != null) {
                    factor = (double)(100 - monitor.getPercentComplete()) / (double)objects.length;
                    monitor.setStatusText(i18n.tr("Exportiere Daten"));
                }
                writer = new XmlWriter(os);
                int i = 0;
                while (i < objects.length) {
                    Object o;
                    if (monitor != null) {
                        monitor.setPercentComplete((int)((double)i * factor));
                    }
                    if ((o = objects[i]) instanceof GenericObject) {
                        String name = BeanUtil.toString((Object)objects[i]);
                        if (name != null && monitor != null) {
                            monitor.log(i18n.tr("Speichere Datensatz {0}", name.toString()));
                        }
                        writer.write((GenericObject)o);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                Logger.error((String)"unable to write xml file", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Export der Daten. " + e.getMessage()));
            }
        }
        finally {
            if (monitor != null) {
                monitor.setStatusText(i18n.tr("Schliesse Export-Datei"));
            }
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (objectType == null) {
            return null;
        }
        if (!GenericObject.class.isAssignableFrom(objectType) && !Address.class.isAssignableFrom(objectType)) {
            return null;
        }
        if (SammelTransfer.class.isAssignableFrom(objectType)) {
            return null;
        }
        if (SepaSammelTransfer.class.isAssignableFrom(objectType)) {
            return null;
        }
        return new IOFormat[]{new IOFormat(){

            @Override
            public String getName() {
                return XMLExporter.this.getName();
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"xml"};
            }
        }};
    }

    @Override
    public String getName() {
        return i18n.tr("Hibiscus-Format");
    }

    @Override
    public boolean suppportsExtension(String ext) {
        return false;
    }
}

