/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.datasource.GenericObject;
import de.willuhn.datasource.db.AbstractDBObject;
import de.willuhn.datasource.rmi.DBObject;
import de.willuhn.datasource.serialize.ObjectFactory;
import de.willuhn.datasource.serialize.XmlReader;
import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Importer;
import de.willuhn.jameica.hbci.messaging.ImportMessage;
import de.willuhn.jameica.hbci.rmi.Kontoauszug;
import de.willuhn.jameica.hbci.rmi.SammelTransfer;
import de.willuhn.jameica.hbci.rmi.SepaSammelTransfer;
import de.willuhn.jameica.hbci.rmi.Umsatz;
import de.willuhn.jameica.hbci.rmi.UmsatzTyp;
import de.willuhn.jameica.messaging.Message;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.MultipleClassLoader;
import de.willuhn.util.ProgressMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Map;

public class XMLImporter
implements Importer {
    protected static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public void doImport(Object context, IOFormat format, InputStream is, ProgressMonitor monitor, BackgroundTask t) throws RemoteException, ApplicationException {
        if (is == null) {
            throw new ApplicationException(i18n.tr("Keine zu importierende Datei ausgew\u00e4hlt"));
        }
        if (format == null) {
            throw new ApplicationException(i18n.tr("Kein Datei-Format ausgew\u00e4hlt"));
        }
        MultipleClassLoader loader = Application.getPluginLoader().getManifest(HBCI.class).getClassLoader();
        XmlReader reader = null;
        try {
            try {
                reader = new XmlReader(is, new ObjectFactory((ClassLoader)loader){
                    private final /* synthetic */ ClassLoader val$loader;
                    {
                        this.val$loader = classLoader;
                    }

                    public GenericObject create(String type, String id, Map values) throws Exception {
                        AbstractDBObject object = (AbstractDBObject)Settings.getDBService().createObject(this.val$loader.loadClass(type), null);
                        for (String name : values.keySet()) {
                            object.setAttribute(name, values.get(name));
                        }
                        return object;
                    }
                });
                if (monitor != null) {
                    monitor.setStatusText(i18n.tr("Lese Datei ein"));
                }
                int created = 0;
                int error = 0;
                DBObject object = null;
                while ((object = (DBObject)reader.read()) != null) {
                    if (monitor != null) {
                        monitor.log(i18n.tr("Datensatz {0}", "" + (created + 1)));
                        if (created > 0 && created % 10 == 0) {
                            monitor.addPercentComplete(1);
                        }
                    }
                    if (t != null && t.isInterrupted()) {
                        throw new OperationCanceledException();
                    }
                    try {
                        object.store();
                        ++created;
                        try {
                            Application.getMessagingFactory().sendMessage((Message)new ImportMessage((GenericObject)object));
                        }
                        catch (Exception ex) {
                            Logger.error((String)"error while sending import message", (Throwable)ex);
                        }
                    }
                    catch (ApplicationException ae) {
                        monitor.log("  " + ae.getMessage());
                        ++error;
                    }
                    catch (Exception e) {
                        Logger.error((String)"unable to import line", (Throwable)e);
                        monitor.log("  " + i18n.tr("Fehler beim Import des Datensatzes: {0}", e.getMessage()));
                        ++error;
                    }
                }
                monitor.setStatusText(i18n.tr("{0} Datens\u00e4tze erfolgreich importiert, {1} fehlerhafte \u00fcbersprungen", new String[]{"" + created, "" + error}));
                monitor.setPercentComplete(100);
            }
            catch (OperationCanceledException oce) {
                Logger.warn((String)"operation cancelled");
                throw new ApplicationException(i18n.tr("Import abgebrochen"));
            }
            catch (Exception e) {
                Logger.error((String)"error while reading file", (Throwable)e);
                throw new ApplicationException(i18n.tr("Fehler beim Import der XML-Datei"));
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Logger.error((String)"error while closing inputstream", (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getName() {
        return i18n.tr("Hibiscus-Format");
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (!GenericObject.class.isAssignableFrom(objectType)) {
            return null;
        }
        if (SammelTransfer.class.isAssignableFrom(objectType)) {
            return null;
        }
        if (SepaSammelTransfer.class.isAssignableFrom(objectType)) {
            return null;
        }
        if (Umsatz.class.isAssignableFrom(objectType)) {
            return null;
        }
        if (UmsatzTyp.class.isAssignableFrom(objectType)) {
            return null;
        }
        if (Kontoauszug.class.isAssignableFrom(objectType)) {
            return null;
        }
        IOFormat f = new IOFormat(){

            @Override
            public String getName() {
                return XMLImporter.this.getName();
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"*.xml"};
            }
        };
        return new IOFormat[]{f};
    }
}

