/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.Settings;
import de.willuhn.jameica.hbci.gui.action.Open;
import de.willuhn.jameica.hbci.io.IOFormat;
import de.willuhn.jameica.hbci.io.Importer;
import de.willuhn.jameica.hbci.rmi.AuslandsUeberweisung;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import io.konik.PdfHandler;
import io.konik.zugferd.Invoice;
import io.konik.zugferd.entity.CreditorFinancialAccount;
import io.konik.zugferd.entity.FinancialInstitution;
import io.konik.zugferd.entity.Header;
import io.konik.zugferd.entity.PaymentMeans;
import io.konik.zugferd.entity.TradeParty;
import io.konik.zugferd.entity.trade.MonetarySummation;
import io.konik.zugferd.entity.trade.Settlement;
import io.konik.zugferd.entity.trade.Trade;
import io.konik.zugferd.unqualified.Amount;
import io.konik.zugferd.unqualified.ZfDate;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ZUGFeRDImporter
implements Importer {
    private static final I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();

    @Override
    public String getName() {
        return i18n.tr("PDF-Rechnung im ZUGFeRD-Format");
    }

    @Override
    public IOFormat[] getIOFormats(Class objectType) {
        if (!AuslandsUeberweisung.class.equals((Object)objectType)) {
            return null;
        }
        IOFormat f = new IOFormat(){

            @Override
            public String getName() {
                return ZUGFeRDImporter.this.getName();
            }

            @Override
            public String[] getFileExtensions() {
                return new String[]{"*.pdf"};
            }
        };
        return new IOFormat[]{f};
    }

    @Override
    public void doImport(Object context, IOFormat format, InputStream is, ProgressMonitor monitor, BackgroundTask bgt) throws RemoteException, ApplicationException {
        Object termin;
        FinancialInstitution inst;
        String name;
        monitor.setStatusText(i18n.tr("Importiere ZUGFeRD-Datei"));
        monitor.setPercentComplete(20);
        AuslandsUeberweisung u = (AuslandsUeberweisung)Settings.getDBService().createObject(AuslandsUeberweisung.class, null);
        PdfHandler handler = new PdfHandler();
        Invoice invoice = handler.extractInvoice(is);
        if (invoice == null) {
            throw new ApplicationException(i18n.tr("Datei enth\u00e4lt keine ZUGFeRD-konforme Rechnung"));
        }
        Header header = invoice.getHeader();
        Trade trade = invoice.getTrade();
        if (trade == null) {
            throw new ApplicationException(i18n.tr("Angaben zum Inhalt fehlen in der Rechnung"));
        }
        Settlement s = trade.getSettlement();
        if (s == null) {
            throw new ApplicationException(i18n.tr("Angaben zur Zahlung fehlen in der Rechnung"));
        }
        MonetarySummation sum = s.getMonetarySummation();
        if (sum == null) {
            throw new ApplicationException(i18n.tr("Angaben zum Betrag fehlen in der Rechnung"));
        }
        Amount am = sum.getGrandTotal();
        if (am == null) {
            throw new ApplicationException(i18n.tr("Angaben zur Summe fehlen in der Rechnung"));
        }
        List pay = s.getPaymentMeans();
        PaymentMeans p = pay != null && pay.size() > 0 ? (PaymentMeans)pay.get(0) : null;
        CreditorFinancialAccount acc = p != null ? p.getPayeeAccount() : null;
        monitor.setPercentComplete(40);
        u.setBetrag(am.getValue().doubleValue());
        String nr = s.getPaymentReference();
        if (nr == null) {
            nr = header != null ? header.getInvoiceNumber() : null;
        }
        u.setEndtoEndId(nr);
        u.setPmtInfId(nr);
        u.setZweck(nr);
        String string = name = acc != null ? StringUtils.trimToNull((String)acc.getAccountName()) : null;
        if (name == null) {
            TradeParty seller;
            TradeParty tradeParty = seller = trade.getAgreement() != null ? trade.getAgreement().getSeller() : null;
            if (seller != null) {
                name = seller.getName();
            }
        }
        u.setGegenkontoName(name);
        if (acc != null) {
            u.setGegenkontoNummer(StringUtils.trimToEmpty((String)acc.getIban()).replace(" ", ""));
        }
        FinancialInstitution financialInstitution = inst = p != null ? p.getPayeeInstitution() : null;
        if (inst != null) {
            u.setGegenkontoBLZ(StringUtils.trimToEmpty((String)inst.getBic()).replace(" ", ""));
        }
        ZfDate zfDate = termin = header != null ? header.getContractualDueDate() : null;
        if (termin == null) {
            ZfDate issued;
            ZfDate zfDate2 = issued = header != null ? header.getIssued() : null;
            if (issued != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime((Date)issued);
                cal.add(5, 7);
                termin = cal.getTime();
            }
        }
        u.setTermin((Date)(termin != null ? termin : new Date()));
        monitor.setStatus(4);
        monitor.setPercentComplete(100);
        monitor.setStatusText(i18n.tr("SEPA-\u00dcberweisung erstellt"));
        new Open().handleAction(u);
    }
}

