/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.hbci.io.csv;

import de.willuhn.jameica.hbci.HBCI;
import de.willuhn.jameica.hbci.gui.dialogs.KontoAuswahlDialog;
import de.willuhn.jameica.hbci.io.csv.Column;
import de.willuhn.jameica.hbci.io.csv.Format;
import de.willuhn.jameica.hbci.io.csv.ImportEvent;
import de.willuhn.jameica.hbci.io.csv.ImportListener;
import de.willuhn.jameica.hbci.io.csv.Profile;
import de.willuhn.jameica.hbci.io.ser.DateSerializer;
import de.willuhn.jameica.hbci.io.ser.DefaultSerializer;
import de.willuhn.jameica.hbci.io.ser.ExtendedUsageSerializer;
import de.willuhn.jameica.hbci.io.ser.ValueSerializer;
import de.willuhn.jameica.hbci.rmi.BaseUeberweisung;
import de.willuhn.jameica.hbci.rmi.Konto;
import de.willuhn.jameica.hbci.server.KontoUtil;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Level;
import de.willuhn.logging.Logger;
import de.willuhn.util.I18N;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;

public abstract class AbstractBaseUeberweisungFormat<T extends BaseUeberweisung>
implements Format<T> {
    private static I18N i18n = Application.getPluginLoader().getPlugin(HBCI.class).getResources().getI18N();
    private ImportListener listener = null;
    private Profile profile = null;
    private Konto konto = null;

    @Override
    public synchronized Profile getDefaultProfile() {
        if (this.profile == null) {
            this.profile = new Profile();
            this.profile.setName(i18n.tr("Default-Profil"));
            this.profile.setSkipLines(1);
            this.profile.setSystem(true);
            DefaultSerializer ts = new DefaultSerializer();
            List<Column> list = this.profile.getColumns();
            int i = 0;
            list.add(new Column("_konto", i18n.tr("Eigene Kontonummer"), i++, ts));
            list.add(new Column("_blz", i18n.tr("Eigene BLZ"), i++, ts));
            int n = ++i;
            list.add(new Column("gegenkontoNummer", i18n.tr("Gegenkonto"), n, ts));
            int n2 = ++i;
            list.add(new Column("gegenkontoBLZ", i18n.tr("Gegenkonto BLZ"), n2, ts));
            int n3 = ++i;
            list.add(new Column("gegenkontoName", i18n.tr("Gegenkonto Inhaber"), n3, ts));
            int n4 = ++i;
            list.add(new Column("betrag", i18n.tr("Betrag"), n4, new ValueSerializer()));
            int n5 = ++i;
            list.add(new Column("termin", i18n.tr("Erinnerungstermin"), n5, new DateSerializer()));
            int n6 = ++i;
            list.add(new Column("zweck", i18n.tr("Verwendungszweck"), n6, ts));
            int n7 = ++i;
            list.add(new Column("zweck2", i18n.tr("Verwendungszweck 2"), n7, ts));
            int n8 = ++i;
            ++i;
            list.add(new Column("weitereVerwendungszwecke", i18n.tr("Weitere Verwendungszwecke"), n8, new ExtendedUsageSerializer()));
        }
        return this.profile;
    }

    @Override
    public ImportListener getImportListener() {
        if (this.listener == null) {
            this.listener = new ImportListener(){

                @Override
                public void beforeSet(ImportEvent event) throws OperationCanceledException {
                    Map values = (Map)event.data;
                    String konto = (String)values.remove("_konto");
                    String blz = (String)values.remove("_blz");
                    try {
                        Konto k = KontoUtil.find(konto, blz);
                        if (k != null) {
                            values.put("konto", k);
                        }
                    }
                    catch (RemoteException re) {
                        Logger.error((String)"error while search for account", (Throwable)re);
                    }
                }

                @Override
                public void beforeStore(ImportEvent event) throws OperationCanceledException {
                    try {
                        Object data = event.data;
                        if (data == null || !(data instanceof BaseUeberweisung)) {
                            return;
                        }
                        BaseUeberweisung u = (BaseUeberweisung)data;
                        if (u.getKonto() == null) {
                            if (AbstractBaseUeberweisungFormat.this.konto == null) {
                                KontoAuswahlDialog d = new KontoAuswahlDialog(1);
                                d.setText(i18n.tr("Bitte w\u00e4hlen Sie das zu verwendende Konto aus."));
                                AbstractBaseUeberweisungFormat.this.konto = (Konto)d.open();
                            }
                            u.setKonto(AbstractBaseUeberweisungFormat.this.konto);
                        }
                    }
                    catch (OperationCanceledException oce) {
                        throw new OperationCanceledException(i18n.tr("Kein Konto ausgew\u00e4hlt"));
                    }
                    catch (Exception e) {
                        Logger.write((Level)Level.WARN, (String)"error while assigning account", (Throwable)e);
                    }
                }
            };
        }
        return this.listener;
    }
}

